/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bindings.boot;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;

final class MapMapper {
    private final Map<String, String> source;
    private final Map<String, Object> destination;

    MapMapper(Map<String, String> source, Map<String, Object> destination) {
        this.source = source;
        this.destination = destination;
    }

    Source from(String ... keys) {
        return new Source(keys);
    }

    final class Source {
        private final String[] keys;

        private Source(String[] keys) {
            this.keys = keys;
        }

        void to(String key) {
            this.to(key, (String v) -> v);
        }

        void to(String key, Function<String, Object> function) {
            if (this.keys.length != 1) {
                throw new IllegalStateException(String.format("source size %d cannot be transformed as one argument", this.keys.length));
            }
            if (!Arrays.stream(this.keys).allMatch(MapMapper.this.source::containsKey)) {
                return;
            }
            MapMapper.this.destination.put(key, function.apply((String)MapMapper.this.source.get(this.keys[0])));
        }

        void to(String key, TriFunction<String, String, String, Object> function) {
            if (this.keys.length != 3) {
                throw new IllegalStateException(String.format("source size %d cannot be consumed as three arguments", this.keys.length));
            }
            if (!Arrays.stream(this.keys).allMatch(MapMapper.this.source::containsKey)) {
                return;
            }
            MapMapper.this.destination.put(key, function.apply((String)MapMapper.this.source.get(this.keys[0]), (String)MapMapper.this.source.get(this.keys[1]), (String)MapMapper.this.source.get(this.keys[2])));
        }
    }

    static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }
}

