/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bindings.boot;

import java.util.Map;
import org.springframework.cloud.bindings.Bindings;
import org.springframework.cloud.bindings.boot.BindingsPropertiesProcessor;
import org.springframework.cloud.bindings.boot.Guards;
import org.springframework.cloud.bindings.boot.MapMapper;
import org.springframework.core.env.Environment;

public final class SqlServerBindingsPropertiesProcessor
implements BindingsPropertiesProcessor {
    public static final String TYPE = "sqlserver";

    @Override
    public void process(Environment environment, Bindings bindings, Map<String, Object> properties) {
        if (!Guards.isTypeEnabled(environment, TYPE)) {
            return;
        }
        bindings.filterBindings(TYPE).forEach(binding -> {
            MapMapper map = new MapMapper(binding.getSecret(), properties);
            map.from("password").to("spring.datasource.password");
            map.from("host", "port", "database").to("spring.datasource.url", (host, port, database) -> String.format("jdbc:sqlserver://%s:%s/%s", host, port, database));
            map.from("username").to("spring.datasource.username");
            properties.put("spring.datasource.driver-class-name", "com.microsoft.sqlserver.jdbc.SQLServerDriver");
            map.from("password").to("spring.r2dbc.password");
            map.from("host", "port", "database").to("spring.r2dbc.url", (host, port, database) -> String.format("r2dbc:sqlserver://%s:%s/%s", host, port, database));
            map.from("username").to("spring.r2dbc.username");
        });
    }
}

