/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bindings.boot;

import java.util.Map;
import org.springframework.cloud.bindings.Bindings;
import org.springframework.cloud.bindings.boot.BindingsPropertiesProcessor;
import org.springframework.cloud.bindings.boot.Guards;
import org.springframework.cloud.bindings.boot.MapMapper;
import org.springframework.core.env.Environment;

public final class MySqlBindingsPropertiesProcessor
implements BindingsPropertiesProcessor {
    public static final String TYPE = "mysql";

    @Override
    public void process(Environment environment, Bindings bindings, Map<String, Object> properties) {
        if (!Guards.isTypeEnabled(environment, TYPE)) {
            return;
        }
        bindings.filterBindings(TYPE).forEach(binding -> {
            MapMapper map = new MapMapper(binding.getSecret(), properties);
            map.from("password").to("spring.datasource.password");
            map.from("host", "port", "database").to("spring.datasource.url", (host, port, database) -> String.format("jdbc:mysql://%s:%s/%s", host, port, database));
            map.from("username").to("spring.datasource.username");
            try {
                Class.forName("org.mariadb.jdbc.Driver", false, this.getClass().getClassLoader());
                properties.put("spring.datasource.driver-class-name", "org.mariadb.jdbc.Driver");
            }
            catch (ClassNotFoundException e) {
                try {
                    Class.forName("com.mysql.cj.jdbc.Driver", false, this.getClass().getClassLoader());
                    properties.put("spring.datasource.driver-class-name", "com.mysql.cj.jdbc.Driver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            map.from("password").to("spring.r2dbc.password");
            map.from("host", "port", "database").to("spring.r2dbc.url", (host, port, database) -> String.format("r2dbc:mysql://%s:%s/%s", host, port, database));
            map.from("username").to("spring.r2dbc.username");
        });
    }
}

