/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.endpoint;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public abstract class AbstractNotificationMessageHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final String NOTIFICATION_REQUEST_ATTRIBUTE_NAME = "NOTIFICATION_REQUEST";
    private final MappingJackson2HttpMessageConverter messageConverter = new MappingJackson2HttpMessageConverter();

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        if (webRequest.getAttribute(NOTIFICATION_REQUEST_ATTRIBUTE_NAME, 0) == null) {
            webRequest.setAttribute(NOTIFICATION_REQUEST_ATTRIBUTE_NAME, this.messageConverter.read(HashMap.class, (HttpInputMessage)this.createInputMessage(webRequest)), 0);
        }
        HashMap content = (HashMap)webRequest.getAttribute(NOTIFICATION_REQUEST_ATTRIBUTE_NAME, 0);
        return this.doResolverArgumentFromNotificationMessage(content);
    }

    protected abstract Object doResolverArgumentFromNotificationMessage(HashMap<String, String> var1);

    private ServletServerHttpRequest createInputMessage(NativeWebRequest webRequest) {
        HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        return new ServletServerHttpRequest(servletRequest);
    }
}

