/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.config.xml;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.cloud.aws.context.config.xml.GlobalBeanDefinitionUtils;
import org.springframework.cloud.aws.messaging.config.xml.BufferedSqsClientBeanDefinitionUtils;
import org.springframework.cloud.aws.messaging.core.QueueMessagingTemplate;
import org.springframework.cloud.aws.messaging.listener.QueueMessageHandler;
import org.springframework.cloud.aws.messaging.listener.SendToHandlerMethodReturnValueHandler;
import org.springframework.cloud.aws.messaging.listener.SimpleMessageListenerContainer;
import org.springframework.core.Conventions;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class AnnotationDrivenQueueListenerBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String TASK_EXECUTOR_ATTRIBUTE = "task-executor";
    private static final String MAX_NUMBER_OF_MESSAGES_ATTRIBUTE = "max-number-of-messages";
    private static final String VISIBILITY_TIMEOUT_ATTRIBUTE = "visibility-timeout";
    private static final String WAIT_TIME_OUT_ATTRIBUTE = "wait-time-out";
    private static final String AUTO_STARTUP_ATTRIBUTE = "auto-startup";
    private static final String DESTINATION_RESOLVER_ATTRIBUTE = "destination-resolver";
    private static final String DELETE_MESSAGE_ON_EXCEPTION_ATTRIBUTE = "delete-message-on-exception";

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder containerBuilder = BeanDefinitionBuilder.genericBeanDefinition(SimpleMessageListenerContainer.class);
        if (StringUtils.hasText((String)element.getAttribute(TASK_EXECUTOR_ATTRIBUTE))) {
            containerBuilder.addPropertyReference(Conventions.attributeNameToPropertyName((String)TASK_EXECUTOR_ATTRIBUTE), element.getAttribute(TASK_EXECUTOR_ATTRIBUTE));
        }
        if (StringUtils.hasText((String)element.getAttribute(MAX_NUMBER_OF_MESSAGES_ATTRIBUTE))) {
            containerBuilder.addPropertyValue(Conventions.attributeNameToPropertyName((String)MAX_NUMBER_OF_MESSAGES_ATTRIBUTE), (Object)element.getAttribute(MAX_NUMBER_OF_MESSAGES_ATTRIBUTE));
        }
        if (StringUtils.hasText((String)element.getAttribute(VISIBILITY_TIMEOUT_ATTRIBUTE))) {
            containerBuilder.addPropertyValue(Conventions.attributeNameToPropertyName((String)VISIBILITY_TIMEOUT_ATTRIBUTE), (Object)element.getAttribute(VISIBILITY_TIMEOUT_ATTRIBUTE));
        }
        if (StringUtils.hasText((String)element.getAttribute(WAIT_TIME_OUT_ATTRIBUTE))) {
            containerBuilder.addPropertyValue(Conventions.attributeNameToPropertyName((String)WAIT_TIME_OUT_ATTRIBUTE), (Object)element.getAttribute(WAIT_TIME_OUT_ATTRIBUTE));
        }
        if (StringUtils.hasText((String)element.getAttribute(AUTO_STARTUP_ATTRIBUTE))) {
            containerBuilder.addPropertyValue(Conventions.attributeNameToPropertyName((String)AUTO_STARTUP_ATTRIBUTE), (Object)element.getAttribute(AUTO_STARTUP_ATTRIBUTE));
        }
        if (StringUtils.hasText((String)element.getAttribute(DESTINATION_RESOLVER_ATTRIBUTE))) {
            containerBuilder.addPropertyReference(Conventions.attributeNameToPropertyName((String)DESTINATION_RESOLVER_ATTRIBUTE), element.getAttribute(DESTINATION_RESOLVER_ATTRIBUTE));
        }
        if (StringUtils.hasText((String)element.getAttribute(DELETE_MESSAGE_ON_EXCEPTION_ATTRIBUTE))) {
            containerBuilder.addPropertyValue(Conventions.attributeNameToPropertyName((String)DELETE_MESSAGE_ON_EXCEPTION_ATTRIBUTE), (Object)element.getAttribute(DELETE_MESSAGE_ON_EXCEPTION_ATTRIBUTE));
        }
        String amazonSqsClientBeanName = BufferedSqsClientBeanDefinitionUtils.getCustomAmazonSqsClientOrDecoratedDefaultSqsClientBeanName(element, parserContext);
        containerBuilder.addPropertyReference(Conventions.attributeNameToPropertyName((String)"amazon-sqs"), amazonSqsClientBeanName);
        containerBuilder.addPropertyReference("resourceIdResolver", GlobalBeanDefinitionUtils.retrieveResourceIdResolverBeanName((BeanDefinitionRegistry)parserContext.getRegistry()));
        containerBuilder.addPropertyReference("messageHandler", AnnotationDrivenQueueListenerBeanDefinitionParser.getMessageHandlerBeanName(element, parserContext, amazonSqsClientBeanName));
        return containerBuilder.getBeanDefinition();
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    private static String getMessageHandlerBeanName(Element element, ParserContext parserContext, String sqsClientBeanName) {
        BeanDefinitionBuilder queueMessageHandlerDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(QueueMessageHandler.class);
        ManagedList<BeanDefinition> argumentResolvers = AnnotationDrivenQueueListenerBeanDefinitionParser.getArgumentResolvers(element, parserContext);
        if (!argumentResolvers.isEmpty()) {
            queueMessageHandlerDefinitionBuilder.addPropertyValue("customArgumentResolvers", argumentResolvers);
        }
        ManagedList<BeanDefinition> returnValueHandlers = AnnotationDrivenQueueListenerBeanDefinitionParser.getReturnValueHandlers(element, parserContext);
        returnValueHandlers.add((Object)AnnotationDrivenQueueListenerBeanDefinitionParser.createSendToHandlerMethodReturnValueHandlerBeanDefinition(element, parserContext, sqsClientBeanName));
        queueMessageHandlerDefinitionBuilder.addPropertyValue("customReturnValueHandlers", returnValueHandlers);
        String messageHandlerBeanName = parserContext.getReaderContext().generateBeanName((BeanDefinition)queueMessageHandlerDefinitionBuilder.getBeanDefinition());
        parserContext.getRegistry().registerBeanDefinition(messageHandlerBeanName, (BeanDefinition)queueMessageHandlerDefinitionBuilder.getBeanDefinition());
        return messageHandlerBeanName;
    }

    private static AbstractBeanDefinition createSendToHandlerMethodReturnValueHandlerBeanDefinition(Element element, ParserContext parserContext, String sqsClientBeanName) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition(SendToHandlerMethodReturnValueHandler.class);
        if (StringUtils.hasText((String)element.getAttribute("send-to-message-template"))) {
            beanDefinitionBuilder.addConstructorArgReference(element.getAttribute("send-to-message-template"));
        } else {
            BeanDefinitionBuilder templateBuilder = BeanDefinitionBuilder.rootBeanDefinition(QueueMessagingTemplate.class);
            templateBuilder.addConstructorArgReference(sqsClientBeanName);
            templateBuilder.addConstructorArgReference(GlobalBeanDefinitionUtils.retrieveResourceIdResolverBeanName((BeanDefinitionRegistry)parserContext.getRegistry()));
            beanDefinitionBuilder.addConstructorArgValue((Object)templateBuilder.getBeanDefinition());
        }
        return beanDefinitionBuilder.getBeanDefinition();
    }

    private static ManagedList<BeanDefinition> getArgumentResolvers(Element element, ParserContext parserContext) {
        Element resolversElement = DomUtils.getChildElementByTagName((Element)element, (String)"argument-resolvers");
        if (resolversElement != null) {
            return AnnotationDrivenQueueListenerBeanDefinitionParser.extractBeanSubElements(resolversElement, parserContext);
        }
        return new ManagedList(0);
    }

    private static ManagedList<BeanDefinition> getReturnValueHandlers(Element element, ParserContext parserContext) {
        Element handlersElement = DomUtils.getChildElementByTagName((Element)element, (String)"return-value-handlers");
        if (handlersElement != null) {
            return AnnotationDrivenQueueListenerBeanDefinitionParser.extractBeanSubElements(handlersElement, parserContext);
        }
        return new ManagedList(0);
    }

    private static ManagedList<BeanDefinition> extractBeanSubElements(Element parentElement, ParserContext parserContext) {
        ManagedList list = new ManagedList();
        list.setSource(parserContext.extractSource((Object)parentElement));
        for (Element beanElement : DomUtils.getChildElementsByTagName((Element)parentElement, (String)"bean")) {
            BeanDefinitionHolder beanDef = parserContext.getDelegate().parseBeanDefinitionElement(beanElement);
            beanDef = parserContext.getDelegate().decorateBeanDefinitionIfRequired(beanElement, beanDef);
            list.add((Object)beanDef.getBeanDefinition());
        }
        return list;
    }
}

