/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.jdbc.config.annotation;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.AmazonRDSClient;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.cloud.aws.context.annotation.ConditionalOnMissingAmazonClient;
import org.springframework.cloud.aws.context.config.annotation.ContextDefaultConfigurationRegistrar;
import org.springframework.cloud.aws.core.config.support.ContextAnnotationConfigUtil;
import org.springframework.cloud.aws.core.env.ResourceIdResolver;
import org.springframework.cloud.aws.core.region.RegionProvider;
import org.springframework.cloud.aws.jdbc.config.annotation.EnableRdsInstance;
import org.springframework.cloud.aws.jdbc.config.annotation.RdsInstanceConfigurer;
import org.springframework.cloud.aws.jdbc.datasource.DataSourceFactory;
import org.springframework.cloud.aws.jdbc.rds.AmazonRdsDataSourceFactoryBean;
import org.springframework.cloud.aws.jdbc.rds.AmazonRdsReadReplicaAwareDataSourceFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Configuration
@Import(value={ContextDefaultConfigurationRegistrar.class})
public class AmazonRdsInstanceConfiguration
implements ImportAware,
BeanFactoryAware {
    private AnnotationAttributes annotationAttributes;
    @Autowired(required=false)
    private AWSCredentialsProvider credentialsProvider;
    @Autowired(required=false)
    private RegionProvider regionProvider;
    private ConfigurableBeanFactory beanFactory;
    private DataSourceFactory dataSourceFactory;

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.annotationAttributes = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableRdsInstance.class.getName(), false));
        Assert.notNull((Object)this.annotationAttributes, (String)("@EnableRdsInstance is not present on importing class " + importMetadata.getClassName()));
    }

    @Autowired(required=false)
    public void setConfigurers(List<RdsInstanceConfigurer> configurers) {
        if (CollectionUtils.isEmpty(configurers)) {
            return;
        }
        if (configurers.size() > 1) {
            throw new IllegalStateException("Only one RdsInstanceConfigurer may exist");
        }
        RdsInstanceConfigurer configurer = configurers.iterator().next();
        this.dataSourceFactory = configurer.getDataSourceFactory();
    }

    @Bean
    @ConditionalOnMissingAmazonClient(value=AmazonRDS.class)
    public AmazonRDS amazonRDS() {
        AmazonRDSClient amazonRds = this.credentialsProvider != null ? new AmazonRDSClient(this.credentialsProvider) : new AmazonRDSClient();
        if (this.regionProvider != null) {
            amazonRds.setRegion(this.regionProvider.getRegion());
        }
        return amazonRds;
    }

    @Bean
    public FactoryBean<DataSource> dataSource(AmazonRDS amazonRds, ResourceIdResolver resourceIdResolver) {
        AmazonRdsDataSourceFactoryBean dataSourceFactoryBean = this.annotationAttributes.getBoolean("readReplicaSupport") ? new AmazonRdsReadReplicaAwareDataSourceFactoryBean(amazonRds, ContextAnnotationConfigUtil.resolveStringValue((ConfigurableBeanFactory)this.beanFactory, (String)this.annotationAttributes.getString("dbInstanceIdentifier")), ContextAnnotationConfigUtil.resolveStringValue((ConfigurableBeanFactory)this.beanFactory, (String)this.annotationAttributes.getString("password"))) : new AmazonRdsDataSourceFactoryBean(amazonRds, ContextAnnotationConfigUtil.resolveStringValue((ConfigurableBeanFactory)this.beanFactory, (String)this.annotationAttributes.getString("dbInstanceIdentifier")), ContextAnnotationConfigUtil.resolveStringValue((ConfigurableBeanFactory)this.beanFactory, (String)this.annotationAttributes.getString("password")));
        if (StringUtils.hasText((String)this.annotationAttributes.getString("username"))) {
            dataSourceFactoryBean.setUsername(ContextAnnotationConfigUtil.resolveStringValue((ConfigurableBeanFactory)this.beanFactory, (String)this.annotationAttributes.getString("username")));
        }
        if (StringUtils.hasText((String)this.annotationAttributes.getString("databaseName"))) {
            dataSourceFactoryBean.setDatabaseName(ContextAnnotationConfigUtil.resolveStringValue((ConfigurableBeanFactory)this.beanFactory, (String)this.annotationAttributes.getString("databaseName")));
        }
        if (this.dataSourceFactory != null) {
            dataSourceFactoryBean.setDataSourceFactory(this.dataSourceFactory);
        }
        dataSourceFactoryBean.setResourceIdResolver(resourceIdResolver);
        return dataSourceFactoryBean;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (ConfigurableBeanFactory)beanFactory;
    }
}

