/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.context.config.xml;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.cloud.aws.core.config.xml.XmlWebserviceConfigurationUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class ContextInstanceDataPropertySourceBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String POST_PROCESSOR_CLASS_NAME = "org.springframework.cloud.aws.context.config.AmazonEc2InstanceDataPropertySourcePostProcessor";
    private static final String POST_PROCESSOR_BEAN_NAME = "AmazonEc2InstanceDataPropertySourcePostProcessor";
    private static final String USER_TAGS_BEAN_CLASS_NAME = "org.springframework.cloud.aws.core.env.ec2.AmazonEc2InstanceUserTagsFactoryBean";
    private static final String EC2_CLIENT_CLASS_NAME = "com.amazonaws.services.ec2.AmazonEC2Client";

    ContextInstanceDataPropertySourceBeanDefinitionParser() {
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        return POST_PROCESSOR_BEAN_NAME;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder postProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)POST_PROCESSOR_CLASS_NAME);
        if (StringUtils.hasText((String)element.getAttribute("user-tags-map"))) {
            BeanDefinitionBuilder userTagsBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)USER_TAGS_BEAN_CLASS_NAME);
            userTagsBuilder.addConstructorArgReference(XmlWebserviceConfigurationUtils.getCustomClientOrDefaultClientBeanName((Element)element, (ParserContext)parserContext, (String)"amazon-ec2", (String)EC2_CLIENT_CLASS_NAME));
            if (StringUtils.hasText((String)element.getAttribute("instance-id-provider"))) {
                userTagsBuilder.addConstructorArgReference(element.getAttribute("instance-id-provider"));
            }
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)new BeanDefinitionHolder((BeanDefinition)userTagsBuilder.getBeanDefinition(), element.getAttribute("user-tags-map")), (BeanDefinitionRegistry)parserContext.getRegistry());
        }
        return postProcessorBuilder.getBeanDefinition();
    }
}

