/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.cache.config.xml;

import java.util.List;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.cloud.aws.context.config.xml.GlobalBeanDefinitionUtils;
import org.springframework.cloud.aws.core.config.xml.XmlWebserviceConfigurationUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class CacheBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String CACHE_MANAGER = "cacheManager";
    private static final String CACHE_CLUSTER_ELEMENT_NAME = "cache-cluster";
    private static final String CACHE_REF_ELEMENT_NAME = "cache-ref";
    private static final String ELASTICACHE_FACTORY_BEAN = "org.springframework.cloud.aws.cache.ElastiCacheFactoryBean";
    private static final String ELASTI_CACHE_CLIENT_CLASS_NAME = "com.amazonaws.services.elasticache.AmazonElastiCacheClient";

    CacheBeanDefinitionParser() {
    }

    protected String getBeanClassName(Element element) {
        return "org.springframework.cache.support.SimpleCacheManager";
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        if (parserContext.getRegistry().containsBeanDefinition(CACHE_MANAGER)) {
            parserContext.getReaderContext().error("Only one cache manager can be defined", (Object)element);
        }
        builder.addPropertyValue("caches", this.createCacheCollection(element, parserContext));
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        return CACHE_MANAGER;
    }

    private ManagedList<Object> createCacheCollection(Element element, ParserContext parserContext) {
        ManagedList caches = new ManagedList();
        List cacheElements = DomUtils.getChildElements((Element)element);
        block8: for (Element cacheElement : cacheElements) {
            String elementName;
            switch (elementName = cacheElement.getLocalName()) {
                case "cache-ref": {
                    caches.add((Object)new RuntimeBeanReference(cacheElement.getAttribute("ref")));
                    continue block8;
                }
                case "cache-cluster": {
                    String cacheClusterId = CacheBeanDefinitionParser.getRequiredAttribute("name", cacheElement, parserContext);
                    caches.add((Object)CacheBeanDefinitionParser.createElastiCacheFactoryBean(cacheElement, parserContext, cacheClusterId, CacheBeanDefinitionParser.createDefaultCacheFactories(cacheElement, parserContext)));
                    continue block8;
                }
            }
            parserContext.getReaderContext().error("Unknown element detected", parserContext.extractSource((Object)cacheElement));
        }
        return caches;
    }

    private static String getRequiredAttribute(String attributeName, Element source, ParserContext parserContext) {
        if (StringUtils.hasText((String)source.getAttribute(attributeName))) {
            return source.getAttribute(attributeName);
        }
        parserContext.getReaderContext().error("Attribute '" + attributeName + "' is required", (Object)source);
        return null;
    }

    private static ManagedList<BeanDefinition> createDefaultCacheFactories(Element element, ParserContext parserContext) {
        ManagedList result = new ManagedList();
        result.setSource(parserContext.extractSource((Object)element));
        result.add((Object)CacheBeanDefinitionParser.getCacheFactory("org.springframework.cloud.aws.cache.memcached.MemcachedCacheFactory", element));
        result.add((Object)CacheBeanDefinitionParser.getCacheFactory("org.springframework.cloud.aws.cache.redis.RedisCacheFactory", element));
        return result;
    }

    private static BeanDefinition createElastiCacheFactoryBean(Element source, ParserContext parserContext, String clusterId, ManagedList<BeanDefinition> cacheFactories) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)ELASTICACHE_FACTORY_BEAN);
        beanDefinitionBuilder.addConstructorArgReference(XmlWebserviceConfigurationUtils.getCustomClientOrDefaultClientBeanName((Element)source, (ParserContext)parserContext, (String)"amazon-elasti-cache", (String)ELASTI_CACHE_CLIENT_CLASS_NAME));
        beanDefinitionBuilder.addConstructorArgValue((Object)clusterId);
        beanDefinitionBuilder.addConstructorArgReference(GlobalBeanDefinitionUtils.retrieveResourceIdResolverBeanName(parserContext.getRegistry()));
        beanDefinitionBuilder.addConstructorArgValue(cacheFactories);
        return beanDefinitionBuilder.getBeanDefinition();
    }

    private static BeanDefinition getCacheFactory(String className, Element element) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)className);
        if (StringUtils.hasText((String)element.getAttribute("expiration"))) {
            builder.addPropertyValue("expiryTime", (Object)element.getAttribute("expiration"));
        }
        return builder.getBeanDefinition();
    }
}

