/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.autoconfigure.actuate;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchAsync;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchAsyncClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.ExportMetricWriter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.aws.actuate.metrics.BufferingCloudWatchMetricSender;
import org.springframework.cloud.aws.actuate.metrics.CloudWatchMetricSender;
import org.springframework.cloud.aws.actuate.metrics.CloudWatchMetricWriter;
import org.springframework.cloud.aws.autoconfigure.actuate.CloudWatchMetricProperties;
import org.springframework.cloud.aws.autoconfigure.context.ContextCredentialsAutoConfiguration;
import org.springframework.cloud.aws.context.annotation.ConditionalOnMissingAmazonClient;
import org.springframework.cloud.aws.core.region.RegionProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={ContextCredentialsAutoConfiguration.class})
@EnableConfigurationProperties(value={CloudWatchMetricProperties.class})
@ConditionalOnProperty(prefix="cloud.aws.cloudwatch", name={"namespace"})
@ConditionalOnClass(value={AmazonCloudWatchAsync.class})
public class CloudWatchMetricAutoConfiguration {
    @Autowired(required=false)
    private RegionProvider regionProvider;
    @Autowired
    private CloudWatchMetricProperties cloudWatchMetricProperties;

    @Bean
    @ConditionalOnMissingAmazonClient(value=AmazonCloudWatchAsync.class)
    public AmazonCloudWatchAsync amazonCloudWatchAsync(AWSCredentialsProvider credentialsProvider) {
        AmazonCloudWatchAsyncClient serviceClient = new AmazonCloudWatchAsyncClient(credentialsProvider);
        if (this.regionProvider != null) {
            serviceClient.setRegion(this.regionProvider.getRegion());
        }
        return serviceClient;
    }

    @Bean
    @ExportMetricWriter
    CloudWatchMetricWriter cloudWatchMetricWriter(CloudWatchMetricSender cloudWatchMetricSender) {
        return new CloudWatchMetricWriter(cloudWatchMetricSender);
    }

    @Bean
    @ConditionalOnMissingBean(value={CloudWatchMetricSender.class})
    CloudWatchMetricSender cloudWatchMetricWriterSender(AmazonCloudWatchAsync amazonCloudWatchAsync) {
        return new BufferingCloudWatchMetricSender(this.cloudWatchMetricProperties.getNamespace(), this.cloudWatchMetricProperties.getMaxBuffer(), this.cloudWatchMetricProperties.getFixedDelayBetweenRuns(), amazonCloudWatchAsync);
    }
}

