/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.deployer.manager;

import java.util.HashMap;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class RestartApplicationRequest {
    private final String name;
    private final Map<String, String> properties;

    protected RestartApplicationRequest(String name, Map<String, String> properties) {
        this.name = name;
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static RestartApplicationRequestBuilder builder() {
        return new RestartApplicationRequestBuilder();
    }

    public static final class RestartApplicationRequestBuilder {
        private String name;
        private final Map<String, String> properties = new HashMap<String, String>();

        private RestartApplicationRequestBuilder() {
        }

        public RestartApplicationRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public RestartApplicationRequestBuilder properties(Map<String, String> properties) {
            if (!CollectionUtils.isEmpty(properties)) {
                this.properties.putAll(properties);
            }
            return this;
        }

        public RestartApplicationRequest build() {
            return new RestartApplicationRequest(this.name, this.properties);
        }
    }
}

