/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.deployer.deployer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class GetApplicationResponse {
    private final String id;
    private final String name;
    private final Map<String, Object> environment;
    private final List<String> services;

    protected GetApplicationResponse(String id, String name, Map<String, Object> environment, List<String> services) {
        this.id = id;
        this.name = name;
        this.environment = environment;
        this.services = services;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getEnvironment() {
        return this.environment;
    }

    public List<String> getServices() {
        return this.services;
    }

    public static GetApplicationResponseBuilder builder() {
        return new GetApplicationResponseBuilder();
    }

    public static final class GetApplicationResponseBuilder {
        private String id;
        private String name;
        private final Map<String, Object> environment = new HashMap<String, Object>();
        private final List<String> services = new ArrayList<String>();

        private GetApplicationResponseBuilder() {
        }

        public GetApplicationResponseBuilder id(String id) {
            this.id = id;
            return this;
        }

        public GetApplicationResponseBuilder name(String name) {
            this.name = name;
            return this;
        }

        public GetApplicationResponseBuilder environment(String key, String value) {
            if (key != null && value != null) {
                this.environment.put(key, value);
            }
            return this;
        }

        public GetApplicationResponseBuilder environment(Map<String, Object> environment) {
            if (!CollectionUtils.isEmpty(environment)) {
                this.environment.putAll(environment);
            }
            return this;
        }

        public GetApplicationResponseBuilder service(String service) {
            if (service != null) {
                this.services.add(service);
            }
            return this;
        }

        public GetApplicationResponseBuilder services(List<String> services) {
            if (!CollectionUtils.isEmpty(services)) {
                this.services.addAll(services);
            }
            return this;
        }

        public GetApplicationResponse build() {
            return new GetApplicationResponse(this.id, this.name, this.environment, this.services);
        }
    }
}

