/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.deployer.deployer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class UpdateApplicationRequest {
    private final String name;
    private final String path;
    private final Map<String, String> properties;
    private final Map<String, Object> environment;
    private final List<String> services;
    private final String serviceInstanceId;

    protected UpdateApplicationRequest(String name, String path, Map<String, String> properties, Map<String, Object> environment, List<String> services, String serviceInstanceId) {
        this.name = name;
        this.path = path;
        this.properties = properties;
        this.environment = environment;
        this.services = services;
        this.serviceInstanceId = serviceInstanceId;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, Object> getEnvironment() {
        return this.environment;
    }

    public List<String> getServices() {
        return this.services;
    }

    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    public static UpdateApplicationRequestBuilder builder() {
        return new UpdateApplicationRequestBuilder();
    }

    public static final class UpdateApplicationRequestBuilder {
        private String name;
        private String path;
        private final Map<String, String> properties = new HashMap<String, String>();
        private final Map<String, Object> environment = new HashMap<String, Object>();
        private final List<String> services = new ArrayList<String>();
        private String serviceInstanceId;

        private UpdateApplicationRequestBuilder() {
        }

        public UpdateApplicationRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public UpdateApplicationRequestBuilder path(String path) {
            this.path = path;
            return this;
        }

        public UpdateApplicationRequestBuilder property(String key, String value) {
            if (key != null && value != null) {
                this.properties.put(key, value);
            }
            return this;
        }

        public UpdateApplicationRequestBuilder properties(Map<String, String> properties) {
            if (!CollectionUtils.isEmpty(properties)) {
                this.properties.putAll(properties);
            }
            return this;
        }

        public UpdateApplicationRequestBuilder environment(String key, String value) {
            if (key != null && value != null) {
                this.environment.put(key, value);
            }
            return this;
        }

        public UpdateApplicationRequestBuilder environment(Map<String, Object> environment) {
            if (!CollectionUtils.isEmpty(environment)) {
                this.environment.putAll(environment);
            }
            return this;
        }

        public UpdateApplicationRequestBuilder service(String service) {
            if (service != null) {
                this.services.add(service);
            }
            return this;
        }

        public UpdateApplicationRequestBuilder services(List<String> services) {
            if (!CollectionUtils.isEmpty(services)) {
                this.services.addAll(services);
            }
            return this;
        }

        public UpdateApplicationRequestBuilder serviceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
            return this;
        }

        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this.name, this.path, this.properties, this.environment, this.services, this.serviceInstanceId);
        }
    }
}

