/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.deployer.deployer;

import java.util.HashMap;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class GetServiceInstanceRequest {
    private final String name;
    private final String serviceInstanceId;
    private final Map<String, String> properties;

    protected GetServiceInstanceRequest(String name, String serviceInstanceId, Map<String, String> properties) {
        this.name = name;
        this.serviceInstanceId = serviceInstanceId;
        this.properties = properties;
    }

    public static GetServiceInstanceRequestBuilder builder() {
        return new GetServiceInstanceRequestBuilder();
    }

    public String getName() {
        return this.name;
    }

    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static final class GetServiceInstanceRequestBuilder {
        private String name;
        private String serviceInstanceId;
        private final Map<String, String> properties = new HashMap<String, String>();

        private GetServiceInstanceRequestBuilder() {
        }

        public GetServiceInstanceRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public GetServiceInstanceRequestBuilder serviceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
            return this;
        }

        public GetServiceInstanceRequestBuilder properties(Map<String, String> properties) {
            if (!CollectionUtils.isEmpty(properties)) {
                this.properties.putAll(properties);
            }
            return this;
        }

        public GetServiceInstanceRequest build() {
            return new GetServiceInstanceRequest(this.name, this.serviceInstanceId, this.properties);
        }
    }
}

