/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.oauth2;

import java.util.Objects;

public class DeleteOAuth2ClientRequest {
    private final String clientId;
    private final String identityZoneSubdomain;
    private final String identityZoneId;

    protected DeleteOAuth2ClientRequest(String clientId, String identityZoneSubdomain, String identityZoneId) {
        this.clientId = clientId;
        this.identityZoneSubdomain = identityZoneSubdomain;
        this.identityZoneId = identityZoneId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getIdentityZoneSubdomain() {
        return this.identityZoneSubdomain;
    }

    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    public static DeleteOAuth2ClientRequestBuilder builder() {
        return new DeleteOAuth2ClientRequestBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteOAuth2ClientRequest)) {
            return false;
        }
        DeleteOAuth2ClientRequest that = (DeleteOAuth2ClientRequest)o;
        return Objects.equals(this.clientId, that.clientId) && Objects.equals(this.identityZoneSubdomain, that.identityZoneSubdomain) && Objects.equals(this.identityZoneId, that.identityZoneId);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.identityZoneSubdomain, this.identityZoneId);
    }

    public String toString() {
        return "DeleteOAuth2ClientRequest{clientId='" + this.clientId + '\'' + ", identityZoneSubdomain='" + this.identityZoneSubdomain + '\'' + ", identityZoneId='" + this.identityZoneId + '\'' + '}';
    }

    public static final class DeleteOAuth2ClientRequestBuilder {
        private String clientId;
        private String identityZoneSubdomain;
        private String identityZoneId;

        private DeleteOAuth2ClientRequestBuilder() {
        }

        public DeleteOAuth2ClientRequestBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public DeleteOAuth2ClientRequestBuilder identityZoneSubdomain(String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
            return this;
        }

        public DeleteOAuth2ClientRequestBuilder identityZoneId(String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public DeleteOAuth2ClientRequest build() {
            return new DeleteOAuth2ClientRequest(this.clientId, this.identityZoneSubdomain, this.identityZoneId);
        }
    }
}

