/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.deployer;

import java.util.HashMap;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class UpdateServiceInstanceRequest {
    private final String serviceInstanceName;
    private final Map<String, Object> parameters;
    private final Map<String, String> properties;
    private final boolean rebindOnUpdate;

    UpdateServiceInstanceRequest(String serviceInstanceName, Map<String, Object> parameters, Map<String, String> properties, boolean rebindOnUpdate) {
        this.serviceInstanceName = serviceInstanceName;
        this.parameters = parameters;
        this.properties = properties;
        this.rebindOnUpdate = rebindOnUpdate;
    }

    public static UpdateServiceInstanceRequestBuilder builder() {
        return new UpdateServiceInstanceRequestBuilder();
    }

    public String getServiceInstanceName() {
        return this.serviceInstanceName;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isRebindOnUpdate() {
        return this.rebindOnUpdate;
    }

    public static class UpdateServiceInstanceRequestBuilder {
        private String serviceInstanceName;
        private final Map<String, Object> parameters = new HashMap<String, Object>();
        private final Map<String, String> properties = new HashMap<String, String>();
        private boolean rebindOnUpdate;

        UpdateServiceInstanceRequestBuilder() {
        }

        public UpdateServiceInstanceRequestBuilder serviceInstanceName(String serviceInstanceName) {
            this.serviceInstanceName = serviceInstanceName;
            return this;
        }

        public UpdateServiceInstanceRequestBuilder parameters(String key, String value) {
            if (key != null && value != null) {
                this.parameters.put(key, value);
            }
            return this;
        }

        public UpdateServiceInstanceRequestBuilder parameters(Map<String, Object> parameters) {
            if (!CollectionUtils.isEmpty(parameters)) {
                this.parameters.putAll(parameters);
            }
            return this;
        }

        public UpdateServiceInstanceRequestBuilder properties(Map<String, String> properties) {
            if (!CollectionUtils.isEmpty(properties)) {
                this.properties.putAll(properties);
            }
            return this;
        }

        public UpdateServiceInstanceRequestBuilder rebindOnUpdate(boolean rebindOnUpdate) {
            this.rebindOnUpdate = rebindOnUpdate;
            return this;
        }

        public UpdateServiceInstanceRequest build() {
            return new UpdateServiceInstanceRequest(this.serviceInstanceName, this.parameters, this.properties, this.rebindOnUpdate);
        }
    }
}

