/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.deployer.cloudfoundry;

import org.cloudfoundry.operations.applications.RestageApplicationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.appbroker.deployer.cloudfoundry.CloudFoundryOperationsUtils;
import org.springframework.cloud.appbroker.manager.AppManager;
import org.springframework.cloud.appbroker.manager.RestartApplicationRequest;
import org.springframework.cloud.appbroker.manager.StartApplicationRequest;
import org.springframework.cloud.appbroker.manager.StopApplicationRequest;
import reactor.core.publisher.Mono;

public class CloudFoundryAppManager
implements AppManager {
    private final Logger logger = LoggerFactory.getLogger(CloudFoundryAppManager.class);
    private final CloudFoundryOperationsUtils operationsUtils;

    public CloudFoundryAppManager(CloudFoundryOperationsUtils operationsUtils) {
        this.operationsUtils = operationsUtils;
    }

    public Mono<Void> start(StartApplicationRequest request) {
        return Mono.justOrEmpty((Object)request).flatMap(req -> this.operationsUtils.getOperations(req.getProperties()).flatMap(cfOperations -> Mono.justOrEmpty((Object)req.getName()).flatMap(appName -> cfOperations.applications().start(org.cloudfoundry.operations.applications.StartApplicationRequest.builder().name(appName).build()).doOnRequest(l -> this.logger.debug("Starting application {}", appName)).doOnSuccess(item -> this.logger.info("Successfully started application {}", appName)).doOnError(error -> this.logger.error("Failed to start application {}", appName)))));
    }

    public Mono<Void> stop(StopApplicationRequest request) {
        return Mono.justOrEmpty((Object)request).flatMap(req -> this.operationsUtils.getOperations(req.getProperties()).flatMap(cfOperations -> Mono.justOrEmpty((Object)req.getName()).flatMap(appName -> cfOperations.applications().stop(org.cloudfoundry.operations.applications.StopApplicationRequest.builder().name(appName).build()).doOnRequest(l -> this.logger.debug("Stopping application {}", appName)).doOnSuccess(item -> this.logger.info("Successfully stopped application {}", appName)).doOnError(error -> this.logger.error("Failed to stop application {}", appName)))));
    }

    public Mono<Void> restart(RestartApplicationRequest request) {
        return Mono.justOrEmpty((Object)request).flatMap(req -> this.operationsUtils.getOperations(req.getProperties()).flatMap(cfOperations -> Mono.justOrEmpty((Object)req.getName()).flatMap(appName -> cfOperations.applications().restart(org.cloudfoundry.operations.applications.RestartApplicationRequest.builder().name(appName).build()).doOnRequest(l -> this.logger.debug("Restarting application {}", appName)).doOnSuccess(item -> this.logger.info("Successfully restarted application {}", appName)).doOnError(error -> this.logger.error("Failed to restart application {}", appName)))));
    }

    public Mono<Void> restage(org.springframework.cloud.appbroker.manager.RestageApplicationRequest request) {
        return Mono.justOrEmpty((Object)request).flatMap(req -> this.operationsUtils.getOperations(req.getProperties()).flatMap(cfOperations -> Mono.justOrEmpty((Object)req.getName()).flatMap(appName -> cfOperations.applications().restage(RestageApplicationRequest.builder().name(appName).build()).doOnRequest(l -> this.logger.debug("Restaging application {}", appName)).doOnSuccess(item -> this.logger.info("Successfully restaged application {}", appName)).doOnError(error -> this.logger.error("Failed to restage application {}", appName)))));
    }
}

