/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.autoconfigure;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.appbroker.autoconfigure.CloudFoundryAppDeployerAutoConfiguration;
import org.springframework.cloud.appbroker.deployer.AppDeployer;
import org.springframework.cloud.appbroker.deployer.BackingAppDeploymentService;
import org.springframework.cloud.appbroker.deployer.BackingApplication;
import org.springframework.cloud.appbroker.deployer.BackingService;
import org.springframework.cloud.appbroker.deployer.BackingServicesProvisionService;
import org.springframework.cloud.appbroker.deployer.BackingSpaceManagementService;
import org.springframework.cloud.appbroker.deployer.BrokeredServices;
import org.springframework.cloud.appbroker.deployer.DefaultBackingAppDeploymentService;
import org.springframework.cloud.appbroker.deployer.DefaultBackingServicesProvisionService;
import org.springframework.cloud.appbroker.deployer.DefaultBackingSpaceManagementService;
import org.springframework.cloud.appbroker.deployer.DeployerClient;
import org.springframework.cloud.appbroker.extensions.parameters.BackingApplicationsParametersTransformationService;
import org.springframework.cloud.appbroker.extensions.parameters.BackingServicesParametersTransformationService;
import org.springframework.cloud.appbroker.extensions.parameters.EnvironmentMappingParametersTransformerFactory;
import org.springframework.cloud.appbroker.extensions.parameters.ParameterMappingParametersTransformerFactory;
import org.springframework.cloud.appbroker.extensions.parameters.ParametersTransformerFactory;
import org.springframework.cloud.appbroker.extensions.parameters.PropertyMappingParametersTransformerFactory;
import org.springframework.cloud.appbroker.extensions.targets.ServiceInstanceGuidSuffix;
import org.springframework.cloud.appbroker.extensions.targets.SpacePerServiceInstance;
import org.springframework.cloud.appbroker.extensions.targets.TargetFactory;
import org.springframework.cloud.appbroker.extensions.targets.TargetService;
import org.springframework.cloud.appbroker.manager.AppManager;
import org.springframework.cloud.appbroker.manager.BackingAppManagementService;
import org.springframework.cloud.appbroker.manager.ManagementClient;
import org.springframework.cloud.appbroker.service.CreateServiceInstanceAppBindingWorkflow;
import org.springframework.cloud.appbroker.service.CreateServiceInstanceRouteBindingWorkflow;
import org.springframework.cloud.appbroker.service.CreateServiceInstanceWorkflow;
import org.springframework.cloud.appbroker.service.DeleteServiceInstanceBindingWorkflow;
import org.springframework.cloud.appbroker.service.DeleteServiceInstanceWorkflow;
import org.springframework.cloud.appbroker.service.UpdateServiceInstanceWorkflow;
import org.springframework.cloud.appbroker.service.WorkflowServiceInstanceBindingService;
import org.springframework.cloud.appbroker.service.WorkflowServiceInstanceService;
import org.springframework.cloud.appbroker.state.InMemoryServiceInstanceBindingStateRepository;
import org.springframework.cloud.appbroker.state.InMemoryServiceInstanceStateRepository;
import org.springframework.cloud.appbroker.state.ServiceInstanceBindingStateRepository;
import org.springframework.cloud.appbroker.state.ServiceInstanceStateRepository;
import org.springframework.cloud.appbroker.workflow.instance.AppDeploymentCreateServiceInstanceWorkflow;
import org.springframework.cloud.appbroker.workflow.instance.AppDeploymentDeleteServiceInstanceWorkflow;
import org.springframework.cloud.appbroker.workflow.instance.AppDeploymentUpdateServiceInstanceWorkflow;
import org.springframework.cloud.servicebroker.service.ServiceInstanceBindingService;
import org.springframework.cloud.servicebroker.service.ServiceInstanceService;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={CloudFoundryAppDeployerAutoConfiguration.class})
@ConditionalOnBean(value={AppDeployer.class})
public class AppBrokerAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(AppBrokerAutoConfiguration.class);
    private static final String PROPERTY_PREFIX = "spring.cloud.appbroker";

    @Bean
    public DeployerClient deployerClient(AppDeployer appDeployer) {
        return new DeployerClient(appDeployer);
    }

    @Bean
    @ConditionalOnMissingBean
    public BackingAppDeploymentService backingAppDeploymentService(DeployerClient deployerClient) {
        return new DefaultBackingAppDeploymentService(deployerClient);
    }

    @Bean
    public ManagementClient managementClient(AppManager appManager) {
        return new ManagementClient(appManager);
    }

    @Bean
    public BackingAppManagementService backingAppManagementService(ManagementClient managementClient, AppDeployer appDeployer, BrokeredServices brokeredServices, TargetService targetService) {
        return new BackingAppManagementService(managementClient, appDeployer, brokeredServices, targetService);
    }

    @Bean
    @ConfigurationProperties(value="spring.cloud.appbroker.services")
    @ConditionalOnMissingBean
    public BrokeredServices brokeredServices() {
        return BrokeredServices.builder().build();
    }

    @Bean
    @ConditionalOnMissingBean(value={ServiceInstanceStateRepository.class})
    public ServiceInstanceStateRepository serviceInstanceStateRepository() {
        if (LOG.isWarnEnabled()) {
            LOG.warn("The InMemoryServiceInstanceStateRepository is provided for demonstration and testing purposes only. It is not suitable for production applications!");
        }
        return new InMemoryServiceInstanceStateRepository();
    }

    @Bean
    @ConditionalOnMissingBean(value={ServiceInstanceBindingStateRepository.class})
    public ServiceInstanceBindingStateRepository serviceInstanceBindingStateRepository() {
        if (LOG.isWarnEnabled()) {
            LOG.warn("The InMemoryServiceInstanceBindingStateRepository is provided for demonstration and testing purposes only. It is not suitable for production applications!");
        }
        return new InMemoryServiceInstanceBindingStateRepository();
    }

    @Bean
    public EnvironmentMappingParametersTransformerFactory environmentMappingParametersTransformerFactory() {
        return new EnvironmentMappingParametersTransformerFactory();
    }

    @Bean
    public PropertyMappingParametersTransformerFactory propertyMappingParametersTransformerFactory() {
        return new PropertyMappingParametersTransformerFactory();
    }

    @Bean
    public ParameterMappingParametersTransformerFactory parameterMappingParametersTransformerFactory() {
        return new ParameterMappingParametersTransformerFactory();
    }

    @Bean
    public BackingApplicationsParametersTransformationService backingApplicationsParametersTransformationService(List<ParametersTransformerFactory<BackingApplication, ?>> transformers) {
        return new BackingApplicationsParametersTransformationService(transformers);
    }

    @Bean
    public BackingServicesParametersTransformationService backingServicesParametersTransformationService(List<ParametersTransformerFactory<BackingService, ?>> transformers) {
        return new BackingServicesParametersTransformationService(transformers);
    }

    @Bean
    public SpacePerServiceInstance spacePerServiceInstance() {
        return new SpacePerServiceInstance();
    }

    @Bean
    public ServiceInstanceGuidSuffix serviceInstanceGuidSuffix() {
        return new ServiceInstanceGuidSuffix();
    }

    @Bean
    public TargetService targetService(List<TargetFactory<?>> targets) {
        return new TargetService(targets);
    }

    @Bean
    @ConditionalOnMissingBean
    public BackingServicesProvisionService backingServicesProvisionService(DeployerClient deployerClient) {
        return new DefaultBackingServicesProvisionService(deployerClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public BackingSpaceManagementService backingSpaceProvisionService(DeployerClient deployerClient) {
        return new DefaultBackingSpaceManagementService(deployerClient);
    }

    @Bean
    public CreateServiceInstanceWorkflow appDeploymentCreateServiceInstanceWorkflow(BrokeredServices brokeredServices, BackingAppDeploymentService backingAppDeploymentService, BackingApplicationsParametersTransformationService appsParametersTransformationService, BackingServicesParametersTransformationService servicesParametersTransformationService, TargetService targetService, BackingServicesProvisionService backingServicesProvisionService) {
        return new AppDeploymentCreateServiceInstanceWorkflow(brokeredServices, backingAppDeploymentService, backingServicesProvisionService, appsParametersTransformationService, servicesParametersTransformationService, targetService);
    }

    @Bean
    public UpdateServiceInstanceWorkflow appDeploymentUpdateServiceInstanceWorkflow(BrokeredServices brokeredServices, BackingAppDeploymentService backingAppDeploymentService, BackingAppManagementService backingAppManagementService, BackingServicesProvisionService backingServicesProvisionService, BackingApplicationsParametersTransformationService appsParametersTransformationService, BackingServicesParametersTransformationService servicesParametersTransformationService, TargetService targetService) {
        return new AppDeploymentUpdateServiceInstanceWorkflow(brokeredServices, backingAppDeploymentService, backingAppManagementService, backingServicesProvisionService, appsParametersTransformationService, servicesParametersTransformationService, targetService);
    }

    @Bean
    public DeleteServiceInstanceWorkflow appDeploymentDeleteServiceInstanceWorkflow(BrokeredServices brokeredServices, BackingAppDeploymentService backingAppDeploymentService, BackingAppManagementService backingAppManagementService, BackingServicesProvisionService backingServicesProvisionService, BackingSpaceManagementService backingSpaceManagementService, TargetService targetService) {
        return new AppDeploymentDeleteServiceInstanceWorkflow(brokeredServices, backingAppDeploymentService, backingAppManagementService, backingServicesProvisionService, backingSpaceManagementService, targetService);
    }

    @Bean
    @ConditionalOnMissingBean(value={ServiceInstanceService.class})
    public WorkflowServiceInstanceService serviceInstanceService(ServiceInstanceStateRepository stateRepository, List<CreateServiceInstanceWorkflow> createWorkflows, List<DeleteServiceInstanceWorkflow> deleteWorkflows, List<UpdateServiceInstanceWorkflow> updateWorkflows) {
        return new WorkflowServiceInstanceService(stateRepository, createWorkflows, deleteWorkflows, updateWorkflows);
    }

    @Bean
    @ConditionalOnMissingBean(value={ServiceInstanceBindingService.class})
    public WorkflowServiceInstanceBindingService serviceInstanceBindingService(ServiceInstanceBindingStateRepository stateRepository, @Autowired(required=false) List<CreateServiceInstanceAppBindingWorkflow> createServiceInstanceAppBindingWorkflows, @Autowired(required=false) List<CreateServiceInstanceRouteBindingWorkflow> createServiceInstanceRouteBindingWorkflows, @Autowired(required=false) List<DeleteServiceInstanceBindingWorkflow> deleteServiceInstanceBindingWorkflows) {
        return new WorkflowServiceInstanceBindingService(stateRepository, createServiceInstanceAppBindingWorkflows, createServiceInstanceRouteBindingWorkflows, deleteServiceInstanceBindingWorkflows);
    }
}

