/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.sentinel.custom;

import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.cloud.alibaba.sentinel.annotation.SentinelRestTemplate;
import org.springframework.cloud.alibaba.sentinel.custom.SentinelProtectInterceptor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

public class SentinelBeanPostProcessor
implements MergedBeanDefinitionPostProcessor {
    @Autowired
    private ApplicationContext applicationContext;
    private ConcurrentHashMap<String, SentinelRestTemplate> cache = new ConcurrentHashMap();

    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class<?> beanType, String beanName) {
        if (this.checkSentinelProtect(beanDefinition, beanType)) {
            SentinelRestTemplate sentinelRestTemplate = ((StandardMethodMetadata)beanDefinition.getSource()).getIntrospectedMethod().getAnnotation(SentinelRestTemplate.class);
            this.cache.put(beanName, sentinelRestTemplate);
        }
    }

    private boolean checkSentinelProtect(RootBeanDefinition beanDefinition, Class<?> beanType) {
        return beanType == RestTemplate.class && beanDefinition.getSource() instanceof StandardMethodMetadata && ((StandardMethodMetadata)beanDefinition.getSource()).isAnnotated(SentinelRestTemplate.class.getName());
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (this.cache.containsKey(beanName)) {
            StringBuilder interceptorBeanName = new StringBuilder();
            SentinelRestTemplate sentinelRestTemplate = this.cache.get(beanName);
            interceptorBeanName.append(StringUtils.uncapitalize((String)SentinelProtectInterceptor.class.getSimpleName())).append("_").append(sentinelRestTemplate.blockHandlerClass().getSimpleName()).append(sentinelRestTemplate.blockHandler()).append("_").append(sentinelRestTemplate.fallbackClass().getSimpleName()).append(sentinelRestTemplate.fallback());
            RestTemplate restTemplate = (RestTemplate)bean;
            this.registerBean(interceptorBeanName.toString(), sentinelRestTemplate);
            SentinelProtectInterceptor sentinelProtectInterceptor = (SentinelProtectInterceptor)this.applicationContext.getBean(interceptorBeanName.toString(), SentinelProtectInterceptor.class);
            restTemplate.getInterceptors().add(sentinelProtectInterceptor);
        }
        return bean;
    }

    private void registerBean(String interceptorBeanName, SentinelRestTemplate sentinelRestTemplate) {
        DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory();
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(SentinelProtectInterceptor.class);
        beanDefinitionBuilder.addConstructorArgValue((Object)sentinelRestTemplate);
        AbstractBeanDefinition interceptorBeanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        beanFactory.registerBeanDefinition(interceptorBeanName, (BeanDefinition)interceptorBeanDefinition);
    }
}

