/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.seata.feign;

import com.alibaba.fescar.core.context.RootContext;
import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.util.StringUtils;

public class SeataFeignClient
implements Client {
    private final Client delegate;
    private final BeanFactory beanFactory;

    SeataFeignClient(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.delegate = new Client.Default(null, null);
    }

    SeataFeignClient(BeanFactory beanFactory, Client delegate) {
        this.delegate = delegate;
        this.beanFactory = beanFactory;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        Request modifiedRequest = this.getModifyRequest(request);
        return this.delegate.execute(modifiedRequest, options);
    }

    private Request getModifyRequest(Request request) {
        String xid = RootContext.getXID();
        if (StringUtils.isEmpty((Object)xid)) {
            return request;
        }
        HashMap headers = new HashMap();
        headers.putAll(request.headers());
        ArrayList<String> fescarXid = new ArrayList<String>();
        fescarXid.add(xid);
        headers.put("TX_XID", fescarXid);
        return Request.create((String)request.method(), (String)request.url(), headers, (byte[])request.body(), (Charset)request.charset());
    }
}

