/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.launcher.deployer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.Ordered;

@ConfigurationProperties(prefix="spring.cloud.launcher")
public class DeployerProperties {
    @NotNull
    private Map<String, Deployable> deployables = new LinkedHashMap<String, Deployable>();
    @NotNull
    private List<String> deploy = new ArrayList<String>();
    private boolean list = false;
    private int statusSleepMillis = 300;

    public boolean isList() {
        return this.list;
    }

    public void setList(boolean list) {
        this.list = list;
    }

    public Map<String, Deployable> getDeployables() {
        return this.deployables;
    }

    public void setDeployables(Map<String, Deployable> deployables) {
        this.deployables = deployables;
    }

    public List<String> getDeploy() {
        return this.deploy;
    }

    public void setDeploy(List<String> deploy) {
        this.deploy = deploy;
    }

    public int getStatusSleepMillis() {
        return this.statusSleepMillis;
    }

    public void setStatusSleepMillis(int statusSleepMillis) {
        this.statusSleepMillis = statusSleepMillis;
    }

    @PostConstruct
    public void init() {
        for (String name : this.deployables.keySet()) {
            Deployable deployable = this.deployables.get(name);
            if (deployable.getName() != null) continue;
            deployable.setName(name);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DeployerProperties{");
        sb.append("deployables=").append(this.deployables);
        sb.append(", deploy=").append(this.deploy);
        sb.append(", statusSleepMillis=").append(this.statusSleepMillis);
        sb.append('}');
        return sb.toString();
    }

    public static class Deployable
    implements Ordered {
        @NotEmpty
        private String coordinates;
        @NotEmpty
        private String name;
        private int port = 0;
        private boolean waitUntilStarted;
        private int order = 0;
        private String message;
        private Map<String, String> disabled = new LinkedHashMap<String, String>();
        private Map<String, String> enabled = new LinkedHashMap<String, String>();
        private Map<String, String> properties = new LinkedHashMap<String, String>();

        public String getCoordinates() {
            return this.coordinates;
        }

        public void setCoordinates(String coordinates) {
            this.coordinates = coordinates;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public boolean isWaitUntilStarted() {
            return this.waitUntilStarted;
        }

        public void setWaitUntilStarted(boolean waitUntilStarted) {
            this.waitUntilStarted = waitUntilStarted;
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setDisabled(Map<String, String> disabled) {
            this.disabled = disabled;
        }

        public Map<String, String> getDisabled() {
            return this.disabled;
        }

        public Map<String, String> getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Map<String, String> enabled) {
            this.enabled = enabled;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("Deployable{");
            sb.append("coordinates='").append(this.coordinates).append('\'');
            sb.append(", name='").append(this.name).append('\'');
            sb.append(", port=").append(this.port);
            sb.append(", waitUntilStarted=").append(this.waitUntilStarted);
            sb.append(", order=").append(this.order);
            sb.append(", disabled=").append(this.disabled);
            sb.append(", enabled=").append(this.disabled);
            sb.append(", properties=").append(this.properties);
            sb.append(", message=").append(this.message);
            sb.append('}');
            return sb.toString();
        }
    }
}

