/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.structured;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.json.JsonWriter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ContextPairs {
    private final boolean include;
    private final String prefix;

    ContextPairs(boolean include, @Nullable String prefix) {
        this.include = include;
        this.prefix = prefix != null ? prefix : "";
    }

    public <T> BiConsumer<T, BiConsumer<String, Object>> flat(String delimiter, Consumer<Pairs<T>> pairs) {
        return this.flat(this.joinWith(delimiter), pairs);
    }

    public <T> BiConsumer<T, BiConsumer<String, Object>> flat(Joiner joiner, Consumer<Pairs<T>> pairs) {
        return !this.include ? this.none() : new Pairs<T>(joiner, pairs)::flat;
    }

    public <T> BiConsumer<T, BiConsumer<String, Object>> nested(Consumer<Pairs<T>> pairs) {
        return !this.include ? this.none() : new Pairs<T>(this.joinWith("."), pairs)::nested;
    }

    private <T, V> BiConsumer<T, BiConsumer<String, V>> none() {
        return (item, pairs) -> {};
    }

    private Joiner joinWith(String delimiter) {
        return (prefix, name) -> {
            StringBuilder joined = new StringBuilder(prefix.length() + delimiter.length() + name.length());
            joined.append(prefix);
            if (!(prefix.isEmpty() || prefix.endsWith(delimiter) || name.startsWith(delimiter))) {
                joined.append(delimiter);
            }
            joined.append(name);
            return joined.toString();
        };
    }

    @FunctionalInterface
    public static interface Joiner {
        public @Nullable String join(String var1, String var2);
    }

    public class Pairs<T> {
        private final Joiner joiner;
        private final List<BiConsumer<T, BiConsumer<String, ?>>> addedPairs;

        Pairs(Joiner joiner, Consumer<Pairs<T>> pairs) {
            this.joiner = joiner;
            this.addedPairs = new ArrayList();
            pairs.accept(this);
        }

        public <V> void addMapEntries(Function<T, Map<String, V>> extractor) {
            this.add(extractor.andThen(Map::entrySet), Map.Entry::getKey, Map.Entry::getValue);
        }

        public <E> void add(Function<T, @Nullable Iterable<E>> elementsExtractor, JsonWriter.PairExtractor<E> pairExtractor) {
            this.add(elementsExtractor, pairExtractor::getName, pairExtractor::getValue);
        }

        public <E, V> void add(Function<T, @Nullable Iterable<E>> elementsExtractor, Function<E, String> nameExtractor, Function<E, V> valueExtractor) {
            this.add((item, pairs) -> {
                Iterable elements = (Iterable)elementsExtractor.apply(item);
                if (elements != null) {
                    elements.forEach(element -> {
                        String name = (String)nameExtractor.apply(element);
                        Object value = valueExtractor.apply(element);
                        pairs.accept(name, value);
                    });
                }
            });
        }

        public <V> void add(BiConsumer<T, BiConsumer<String, V>> pairs) {
            this.addedPairs.add(pairs);
        }

        void flat(T item, BiConsumer<String, Object> pairs) {
            this.addedPairs.forEach(action -> action.accept(item, this.joining(pairs)));
        }

        void nested(T item, BiConsumer<String, Object> pairs) {
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            this.addedPairs.forEach(addedPair -> addedPair.accept(item, this.joining((name, value) -> {
                StringBuilder part = new StringBuilder(name.length());
                int length = !name.endsWith(".") ? name.length() : name.length() - 1;
                Map destination = result;
                for (int i = 0; i < length; ++i) {
                    char ch = name.charAt(i);
                    if (i == length - 1) {
                        part.append(ch);
                        Object previous = destination.put(part.toString(), value);
                        this.assertNotDuplicateNestedPairs(previous == null, (String)name, length);
                        continue;
                    }
                    if (ch == '.') {
                        Object current = destination.computeIfAbsent(part.toString(), key -> new LinkedHashMap());
                        this.assertNotDuplicateNestedPairs(current instanceof Map, (String)name, i);
                        destination = (Map)current;
                        part.setLength(0);
                        continue;
                    }
                    part.append(ch);
                }
            })));
            result.forEach(pairs);
        }

        private void assertNotDuplicateNestedPairs(boolean expression, String name, int index) {
            Assert.state((boolean)expression, () -> "Duplicate nested pairs added under '%s'".formatted(name.substring(0, index)));
        }

        private <V> BiConsumer<String, V> joining(BiConsumer<String, V> pairs) {
            return (name, value) -> {
                if (StringUtils.hasLength((String)(name = this.joiner.join(ContextPairs.this.prefix, name != null ? name : "")))) {
                    pairs.accept((String)name, (Object)value);
                }
            };
        }
    }
}

