/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.info;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Clock;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import javax.security.auth.x500.X500Principal;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class SslInfo {
    private final SslBundles sslBundles;
    private final Clock clock;

    public SslInfo(SslBundles sslBundles) {
        this(sslBundles, Clock.systemDefaultZone());
    }

    public SslInfo(SslBundles sslBundles, Clock clock) {
        this.sslBundles = sslBundles;
        this.clock = clock;
    }

    public List<BundleInfo> getBundles() {
        return this.sslBundles.getBundleNames().stream().map(name -> new BundleInfo((String)name, this.sslBundles.getBundle((String)name))).toList();
    }

    public BundleInfo getBundle(String name) {
        SslBundle bundle = this.sslBundles.getBundle(name);
        return new BundleInfo(name, bundle);
    }

    public final class BundleInfo {
        private final String name;
        private final List<CertificateChainInfo> certificateChains;
        private final List<CertificateChainInfo> trustStoreCertificateChains;

        private BundleInfo(String name, SslBundle sslBundle) {
            this.name = name;
            this.certificateChains = this.extractCertificateChains(sslBundle.getStores().getKeyStore());
            this.trustStoreCertificateChains = this.extractCertificateChains(sslBundle.getStores().getTrustStore());
        }

        private List<CertificateChainInfo> extractCertificateChains(@Nullable KeyStore keyStore) {
            if (keyStore == null) {
                return Collections.emptyList();
            }
            try {
                return Collections.list(keyStore.aliases()).stream().map(alias -> new CertificateChainInfo(keyStore, (String)alias)).toList();
            }
            catch (KeyStoreException ex) {
                return Collections.emptyList();
            }
        }

        public String getName() {
            return this.name;
        }

        public List<CertificateChainInfo> getCertificateChains() {
            return this.certificateChains;
        }

        public List<CertificateChainInfo> getTrustStoreCertificateChains() {
            return this.trustStoreCertificateChains;
        }
    }

    public static class CertificateValidityInfo {
        static final CertificateValidityInfo VALID = new CertificateValidityInfo(Status.VALID, null, new Object[0]);
        private final Status status;
        private final @Nullable String message;

        CertificateValidityInfo(Status status, @Nullable String message, Object ... messageArgs) {
            this.status = status;
            this.message = message != null ? message.formatted(messageArgs) : null;
        }

        public Status getStatus() {
            return this.status;
        }

        public @Nullable String getMessage() {
            return this.message;
        }

        public static enum Status {
            VALID(true),
            NOT_YET_VALID(false),
            EXPIRED(false);

            private final boolean valid;

            private Status(boolean valid) {
                this.valid = valid;
            }

            public boolean isValid() {
                return this.valid;
            }
        }
    }

    public final class CertificateInfo {
        private final @Nullable X509Certificate certificate;

        private CertificateInfo(Certificate certificate) {
            X509Certificate x509Certificate;
            this.certificate = certificate instanceof X509Certificate ? (x509Certificate = (X509Certificate)certificate) : null;
        }

        public @Nullable String getSubject() {
            return this.extract(X509Certificate::getSubjectX500Principal, X500Principal::getName);
        }

        public @Nullable String getIssuer() {
            return this.extract(X509Certificate::getIssuerX500Principal, X500Principal::getName);
        }

        public @Nullable String getSerialNumber() {
            return this.extract(X509Certificate::getSerialNumber, serial -> serial.toString(16));
        }

        public @Nullable String getVersion() {
            return this.extract(certificate -> "V" + certificate.getVersion());
        }

        public @Nullable String getSignatureAlgorithmName() {
            return this.extract(X509Certificate::getSigAlgName);
        }

        public @Nullable Instant getValidityStarts() {
            return this.extract(X509Certificate::getNotBefore, Date::toInstant);
        }

        public @Nullable Instant getValidityEnds() {
            return this.extract(X509Certificate::getNotAfter, Date::toInstant);
        }

        public @Nullable CertificateValidityInfo getValidity() {
            return this.extract(certificate -> {
                Instant starts = this.getValidityStarts();
                Instant ends = this.getValidityEnds();
                Assert.state((starts != null ? 1 : 0) != 0, (String)"Validity start not found");
                Assert.state((ends != null ? 1 : 0) != 0, (String)"Validity end not found");
                CertificateValidityInfo.Status validity = this.checkValidity(starts, ends);
                return switch (validity.ordinal()) {
                    default -> throw new IncompatibleClassChangeError();
                    case 0 -> CertificateValidityInfo.VALID;
                    case 2 -> new CertificateValidityInfo(CertificateValidityInfo.Status.EXPIRED, "Not valid after %s", ends);
                    case 1 -> new CertificateValidityInfo(CertificateValidityInfo.Status.NOT_YET_VALID, "Not valid before %s", starts);
                };
            });
        }

        private CertificateValidityInfo.Status checkValidity(Instant starts, Instant ends) {
            Instant now = SslInfo.this.clock.instant();
            if (now.isBefore(starts)) {
                return CertificateValidityInfo.Status.NOT_YET_VALID;
            }
            if (now.isAfter(ends)) {
                return CertificateValidityInfo.Status.EXPIRED;
            }
            return CertificateValidityInfo.Status.VALID;
        }

        private <V, R> @Nullable R extract(Function<X509Certificate, V> valueExtractor, Function<V, R> resultExtractor) {
            return this.extract(valueExtractor.andThen(resultExtractor));
        }

        private <R> @Nullable R extract(Function<X509Certificate, R> extractor) {
            return this.certificate != null ? (R)extractor.apply(this.certificate) : null;
        }
    }

    public final class CertificateChainInfo {
        private final String alias;
        private final List<CertificateInfo> certificates;

        CertificateChainInfo(KeyStore keyStore, String alias) {
            this.alias = alias;
            this.certificates = this.extractCertificates(keyStore, alias);
        }

        private List<CertificateInfo> extractCertificates(KeyStore keyStore, String alias) {
            try {
                List<CertificateInfo> certificates = this.readCertificateChain(keyStore, alias);
                if (certificates != null) {
                    return certificates;
                }
                List<CertificateInfo> certificate = this.readCertificate(keyStore, alias);
                if (certificate != null) {
                    return certificate;
                }
                return Collections.emptyList();
            }
            catch (KeyStoreException ex) {
                return Collections.emptyList();
            }
        }

        private @Nullable List<CertificateInfo> readCertificate(KeyStore keyStore, String alias) throws KeyStoreException {
            Certificate certificate = keyStore.getCertificate(alias);
            return certificate != null ? List.of(new CertificateInfo(certificate)) : null;
        }

        private @Nullable List<CertificateInfo> readCertificateChain(KeyStore keyStore, String alias) throws KeyStoreException {
            Object[] certificates = keyStore.getCertificateChain(alias);
            return ObjectUtils.isEmpty((Object[])certificates) ? null : Arrays.stream(certificates).map(x$0 -> new CertificateInfo((Certificate)x$0)).toList();
        }

        public String getAlias() {
            return this.alias;
        }

        public List<CertificateInfo> getCertificates() {
            return this.certificates;
        }
    }
}

