/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.tomcat;

import java.util.ArrayList;
import java.util.Map;
import org.apache.catalina.connector.Connector;
import org.apache.commons.logging.Log;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.openssl.ciphers.OpenSSLCipherConfigurationParser;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundleKey;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.boot.ssl.SslStoreBundle;
import org.springframework.boot.web.server.Ssl;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class SslConnectorCustomizer {
    private final Log logger;
    private final Ssl.ClientAuth clientAuth;
    private final Connector connector;

    SslConnectorCustomizer(Log logger, Connector connector, Ssl.ClientAuth clientAuth) {
        this.logger = logger;
        this.clientAuth = clientAuth;
        this.connector = connector;
    }

    void update(String serverName, SslBundle updatedSslBundle) {
        AbstractHttp11Protocol protocol = (AbstractHttp11Protocol)this.connector.getProtocolHandler();
        String host = serverName != null ? serverName : protocol.getDefaultSSLHostConfigName();
        this.logger.debug((Object)("SSL Bundle for host " + host + " has been updated, reloading SSL configuration"));
        this.addSslHostConfig(protocol, host, updatedSslBundle);
    }

    void customize(SslBundle sslBundle, Map<String, SslBundle> serverNameSslBundles) {
        ProtocolHandler handler = this.connector.getProtocolHandler();
        Assert.state((boolean)(handler instanceof AbstractHttp11Protocol), (String)"To use SSL, the connector's protocol handler must be an AbstractHttp11Protocol subclass");
        this.configureSsl((AbstractHttp11Protocol)handler, sslBundle, serverNameSslBundles);
        this.connector.setScheme("https");
        this.connector.setSecure(true);
    }

    private void configureSsl(AbstractHttp11Protocol<?> protocol, SslBundle sslBundle, Map<String, SslBundle> serverNameSslBundles) {
        protocol.setSSLEnabled(true);
        if (sslBundle != null) {
            this.addSslHostConfig(protocol, protocol.getDefaultSSLHostConfigName(), sslBundle);
        }
        serverNameSslBundles.forEach((serverName, bundle) -> this.addSslHostConfig(protocol, (String)serverName, (SslBundle)bundle));
    }

    private void addSslHostConfig(AbstractHttp11Protocol<?> protocol, String serverName, SslBundle sslBundle) {
        SSLHostConfig sslHostConfig = new SSLHostConfig();
        sslHostConfig.setHostName(serverName);
        this.configureSslClientAuth(sslHostConfig);
        this.applySslBundle(protocol, sslHostConfig, sslBundle);
        protocol.addSslHostConfig(sslHostConfig, true);
    }

    private void applySslBundle(AbstractHttp11Protocol<?> protocol, SSLHostConfig sslHostConfig, SslBundle sslBundle) {
        SslBundleKey key = sslBundle.getKey();
        SslStoreBundle stores = sslBundle.getStores();
        SslOptions options = sslBundle.getOptions();
        sslHostConfig.setSslProtocol(sslBundle.getProtocol());
        SSLHostConfigCertificate certificate = new SSLHostConfigCertificate(sslHostConfig, SSLHostConfigCertificate.Type.UNDEFINED);
        String keystorePassword = stores.getKeyStorePassword() != null ? stores.getKeyStorePassword() : "";
        certificate.setCertificateKeystorePassword(keystorePassword);
        if (key.getPassword() != null) {
            certificate.setCertificateKeyPassword(key.getPassword());
        }
        if (key.getAlias() != null) {
            certificate.setCertificateKeyAlias(key.getAlias());
        }
        sslHostConfig.addCertificate(certificate);
        this.configureCiphers(options, sslHostConfig);
        this.configureSslStores(sslHostConfig, certificate, stores);
        this.configureEnabledProtocols(sslHostConfig, options);
    }

    private void configureCiphers(SslOptions options, SSLHostConfig sslHostConfig) {
        CipherConfiguration cipherConfiguration = CipherConfiguration.from(options);
        if (cipherConfiguration != null) {
            sslHostConfig.setCiphers(cipherConfiguration.tls12Ciphers);
            try {
                sslHostConfig.setCipherSuites(cipherConfiguration.tls13Ciphers);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void configureEnabledProtocols(SSLHostConfig sslHostConfig, SslOptions options) {
        if (options.getEnabledProtocols() != null) {
            String enabledProtocols = StringUtils.arrayToDelimitedString((Object[])options.getEnabledProtocols(), (String)"+");
            sslHostConfig.setProtocols(enabledProtocols);
        }
    }

    private void configureSslClientAuth(SSLHostConfig config) {
        config.setCertificateVerification(Ssl.ClientAuth.map(this.clientAuth, "none", "optional", "required"));
    }

    private void configureSslStores(SSLHostConfig sslHostConfig, SSLHostConfigCertificate certificate, SslStoreBundle stores) {
        try {
            if (stores.getKeyStore() != null) {
                certificate.setCertificateKeystore(stores.getKeyStore());
            }
            if (stores.getTrustStore() != null) {
                sslHostConfig.setTrustStore(stores.getTrustStore());
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not load store: " + ex.getMessage(), ex);
        }
    }

    private static class CipherConfiguration {
        private final String tls12Ciphers;
        private final String tls13Ciphers;

        CipherConfiguration(String tls12Ciphers, String tls13Ciphers) {
            this.tls12Ciphers = tls12Ciphers;
            this.tls13Ciphers = tls13Ciphers;
        }

        static CipherConfiguration from(SslOptions options) {
            ArrayList<String> tls12Ciphers = new ArrayList<String>();
            ArrayList<String> tls13Ciphers = new ArrayList<String>();
            String[] ciphers = options.getCiphers();
            if (ciphers == null || ciphers.length == 0) {
                return null;
            }
            for (String cipher : ciphers) {
                if (CipherConfiguration.isTls13(cipher)) {
                    tls13Ciphers.add(cipher);
                    continue;
                }
                tls12Ciphers.add(cipher);
            }
            return new CipherConfiguration(StringUtils.collectionToCommaDelimitedString(tls12Ciphers), StringUtils.collectionToCommaDelimitedString(tls13Ciphers));
        }

        private static boolean isTls13(String cipher) {
            try {
                return OpenSSLCipherConfigurationParser.isTls13Cipher((String)cipher);
            }
            catch (Exception ex) {
                return false;
            }
        }
    }
}

