/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.structured;

import java.util.Map;
import org.springframework.boot.json.JsonWriter;
import org.springframework.boot.logging.structured.StructureLoggingJsonMembersCustomizer;
import org.springframework.boot.logging.structured.StructuredLoggingJsonProperties;
import org.springframework.boot.util.Instantiator;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

class StructuredLoggingJsonPropertiesJsonMembersCustomizer
implements StructureLoggingJsonMembersCustomizer<Object> {
    private final Instantiator<?> instantiator;
    private final StructuredLoggingJsonProperties properties;

    StructuredLoggingJsonPropertiesJsonMembersCustomizer(Instantiator<?> instantiator, StructuredLoggingJsonProperties properties) {
        this.instantiator = instantiator;
        this.properties = properties;
    }

    @Override
    public void customize(JsonWriter.Members<Object> members) {
        String customizer;
        members.applyingPathFilter(this::filterPath);
        members.applyingNameProcessor(this::renameJsonMembers);
        Map<String, String> add = this.properties.add();
        if (!CollectionUtils.isEmpty(add)) {
            add.forEach(members::add);
        }
        if (StringUtils.hasLength((String)(customizer = this.properties.customizer()))) {
            this.createAndApplyCustomizer(members, customizer);
        }
    }

    String renameJsonMembers(JsonWriter.MemberPath path, String existingName) {
        Map<String, String> rename = this.properties.rename();
        String key = path.toUnescapedString();
        return !CollectionUtils.isEmpty(rename) ? rename.getOrDefault(key, existingName) : existingName;
    }

    boolean filterPath(JsonWriter.MemberPath path) {
        boolean included = CollectionUtils.isEmpty(this.properties.include()) || this.properties.include().contains(path.toUnescapedString());
        boolean excluded = !CollectionUtils.isEmpty(this.properties.exclude()) && this.properties.exclude().contains(path.toUnescapedString());
        return !included || excluded;
    }

    private void createAndApplyCustomizer(JsonWriter.Members<Object> members, String customizerClassName) {
        ((StructureLoggingJsonMembersCustomizer)this.instantiator.instantiate(customizerClassName)).customize(members);
    }
}

