/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.annotation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.OrderComparator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class Configurations {
    private static final Comparator<Object> COMPARATOR = OrderComparator.INSTANCE.thenComparing(other -> other.getClass().getName());
    private final UnaryOperator<Collection<Class<?>>> sorter;
    private final Set<Class<?>> classes;

    protected Configurations(Collection<Class<?>> classes) {
        Assert.notNull(classes, (String)"Classes must not be null");
        Collection<Class<?>> sorted = this.sort(classes);
        this.sorter = null;
        this.classes = Collections.unmodifiableSet(new LinkedHashSet(sorted));
    }

    protected Configurations(UnaryOperator<Collection<Class<?>>> sorter, Collection<Class<?>> classes) {
        Assert.notNull(sorter, (String)"Sorter must not be null");
        Assert.notNull(classes, (String)"Classes must not be null");
        Collection sorted = (Collection)sorter.apply(classes);
        this.sorter = sorter;
        this.classes = Collections.unmodifiableSet(new LinkedHashSet(sorted));
    }

    @Deprecated(since="3.4.0", forRemoval=true)
    protected Collection<Class<?>> sort(Collection<Class<?>> classes) {
        return classes;
    }

    protected final Set<Class<?>> getClasses() {
        return this.classes;
    }

    protected Configurations merge(Configurations other) {
        LinkedHashSet<Class<Object>> mergedClasses = new LinkedHashSet(this.getClasses());
        mergedClasses.addAll(other.getClasses());
        if (this.sorter != null) {
            mergedClasses = new LinkedHashSet((Collection)this.sorter.apply(mergedClasses));
        }
        return this.merge(mergedClasses);
    }

    protected abstract Configurations merge(Set<Class<?>> var1);

    public static Class<?>[] getClasses(Configurations ... configurations) {
        return Configurations.getClasses(Arrays.asList(configurations));
    }

    public static Class<?>[] getClasses(Collection<Configurations> configurations) {
        ArrayList<Configurations> ordered = new ArrayList<Configurations>(configurations);
        ordered.sort(COMPARATOR);
        List<Configurations> collated = Configurations.collate(ordered);
        LinkedHashSet classes = collated.stream().flatMap(Configurations::streamClasses).collect(Collectors.toCollection(LinkedHashSet::new));
        return ClassUtils.toClassArray((Collection)classes);
    }

    private static Stream<Class<?>> streamClasses(Configurations configurations) {
        return configurations.getClasses().stream();
    }

    private static List<Configurations> collate(List<Configurations> orderedConfigurations) {
        LinkedList<Configurations> collated = new LinkedList<Configurations>();
        for (Configurations item : orderedConfigurations) {
            if (collated.isEmpty() || collated.getLast().getClass() != item.getClass()) {
                collated.add(item);
                continue;
            }
            collated.set(collated.size() - 1, collated.getLast().merge(item));
        }
        return collated;
    }
}

