/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.structured;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.springframework.boot.logging.structured.CommonStructuredLogFormat;
import org.springframework.boot.logging.structured.StructuredLogFormatter;
import org.springframework.boot.util.Instantiator;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;

public class StructuredLogFormatterFactory<E> {
    private static final Instantiator.FailureHandler failureHandler = (type, implementationName, failure) -> {
        if (!(failure instanceof ClassNotFoundException)) {
            throw new IllegalArgumentException("Unable to instantiate " + implementationName + " [" + type.getName() + "]", failure);
        }
    };
    private final Class<E> logEventType;
    private final Instantiator<StructuredLogFormatter<E>> instantiator;
    private final CommonFormatters<E> commonFormatters;

    public StructuredLogFormatterFactory(Class<E> logEventType, Environment environment, Consumer<Instantiator.AvailableParameters> availableParameters, Consumer<CommonFormatters<E>> commonFormatters) {
        this.logEventType = logEventType;
        this.instantiator = new Instantiator(StructuredLogFormatter.class, allAvailableParameters -> {
            allAvailableParameters.add(Environment.class, environment);
            if (availableParameters != null) {
                availableParameters.accept((Instantiator.AvailableParameters)allAvailableParameters);
            }
        }, failureHandler);
        this.commonFormatters = new CommonFormatters();
        commonFormatters.accept(this.commonFormatters);
    }

    public StructuredLogFormatter<E> get(String format) {
        StructuredLogFormatter<E> formatter = this.commonFormatters.get(this.instantiator, format);
        StructuredLogFormatter<E> structuredLogFormatter = formatter = formatter != null ? formatter : this.getUsingClassName(format);
        if (formatter != null) {
            return formatter;
        }
        throw new IllegalArgumentException("Unknown format '%s'. Values can be a valid fully-qualified class name or one of the common formats: %s".formatted(format, this.commonFormatters.getCommonNames()));
    }

    private StructuredLogFormatter<E> getUsingClassName(String className) {
        StructuredLogFormatter<E> formatter = this.instantiator.instantiate(className);
        if (formatter != null) {
            this.checkTypeArgument(formatter);
        }
        return formatter;
    }

    private void checkTypeArgument(Object formatter) {
        Class typeArgument = GenericTypeResolver.resolveTypeArgument(formatter.getClass(), StructuredLogFormatter.class);
        Assert.isTrue((boolean)this.logEventType.equals(typeArgument), () -> "Type argument of %s must be %s but was %s".formatted(formatter.getClass().getName(), this.logEventType.getName(), typeArgument != null ? typeArgument.getName() : "null"));
    }

    public static class CommonFormatters<E> {
        private final Map<CommonStructuredLogFormat, CommonFormatterFactory<E>> factories = new TreeMap<CommonStructuredLogFormat, CommonFormatterFactory<E>>();

        public void add(CommonStructuredLogFormat format, CommonFormatterFactory<E> factory) {
            this.factories.put(format, factory);
        }

        Collection<String> getCommonNames() {
            return this.factories.keySet().stream().map(CommonStructuredLogFormat::getId).toList();
        }

        StructuredLogFormatter<E> get(Instantiator<StructuredLogFormatter<E>> instantiator, String format) {
            CommonStructuredLogFormat commonFormat = CommonStructuredLogFormat.forId(format);
            CommonFormatterFactory<E> factory = commonFormat != null ? this.factories.get((Object)commonFormat) : null;
            return factory != null ? factory.createFormatter(instantiator) : null;
        }
    }

    @FunctionalInterface
    public static interface CommonFormatterFactory<E> {
        public StructuredLogFormatter<E> createFormatter(Instantiator<StructuredLogFormatter<E>> var1);
    }
}

