/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.structured;

import java.nio.charset.Charset;
import java.util.function.Consumer;
import org.springframework.boot.json.JsonWriter;
import org.springframework.boot.logging.structured.StructuredLogFormatter;

public abstract class JsonWriterStructuredLogFormatter<E>
implements StructuredLogFormatter<E> {
    private final JsonWriter<E> jsonWriter;

    protected JsonWriterStructuredLogFormatter(Consumer<JsonWriter.Members<E>> members) {
        this(JsonWriter.of(members).withNewLineAtEnd());
    }

    protected JsonWriterStructuredLogFormatter(JsonWriter<E> jsonWriter) {
        this.jsonWriter = jsonWriter;
    }

    @Override
    public String format(E event) {
        return this.jsonWriter.writeToString(event);
    }

    @Override
    public byte[] formatAsBytes(E event, Charset charset) {
        return this.jsonWriter.write(event).toByteArray(charset);
    }
}

