/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.structured;

import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.json.JsonWriter;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public record GraylogExtendedLogFormatService(String name, String version) {
    static final GraylogExtendedLogFormatService NONE = new GraylogExtendedLogFormatService(null, null);

    private GraylogExtendedLogFormatService withDefaults(Environment environment) {
        String name = this.withFallbackProperty(environment, this.name, "spring.application.name");
        String version = this.withFallbackProperty(environment, this.version, "spring.application.version");
        return new GraylogExtendedLogFormatService(name, version);
    }

    private String withFallbackProperty(Environment environment, String value, String property) {
        return !StringUtils.hasLength((String)value) ? environment.getProperty(property) : value;
    }

    public void jsonMembers(JsonWriter.Members<?> members) {
        members.add("host", this::name).whenHasLength();
        members.add("_service_version", this::version).whenHasLength();
    }

    public static GraylogExtendedLogFormatService get(Environment environment) {
        return Binder.get(environment).bind("logging.structured.gelf.service", GraylogExtendedLogFormatService.class).orElse(NONE).withDefaults(environment);
    }
}

