/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.structured;

import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.json.JsonWriter;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public record ElasticCommonSchemaService(String name, String version, String environment, String nodeName) {
    static final ElasticCommonSchemaService NONE = new ElasticCommonSchemaService(null, null, null, null);

    private ElasticCommonSchemaService withDefaults(Environment environment) {
        String name = this.withFallbackProperty(environment, this.name, "spring.application.name");
        String version = this.withFallbackProperty(environment, this.version, "spring.application.version");
        return new ElasticCommonSchemaService(name, version, this.environment, this.nodeName);
    }

    private String withFallbackProperty(Environment environment, String value, String property) {
        return !StringUtils.hasLength((String)value) ? environment.getProperty(property) : value;
    }

    public void jsonMembers(JsonWriter.Members<?> members) {
        members.add("service.name", this::name).whenHasLength();
        members.add("service.version", this::version).whenHasLength();
        members.add("service.environment", this::environment).whenHasLength();
        members.add("service.node.name", this::nodeName).whenHasLength();
    }

    public static ElasticCommonSchemaService get(Environment environment) {
        return Binder.get(environment).bind("logging.structured.ecs.service", ElasticCommonSchemaService.class).orElse(NONE).withDefaults(environment);
    }
}

