/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import java.util.Objects;
import org.slf4j.event.KeyValuePair;
import org.springframework.boot.json.JsonWriter;
import org.springframework.boot.logging.structured.ElasticCommonSchemaService;
import org.springframework.boot.logging.structured.JsonWriterStructuredLogFormatter;
import org.springframework.core.env.Environment;

class ElasticCommonSchemaStructuredLogFormatter
extends JsonWriterStructuredLogFormatter<ILoggingEvent> {
    private static final JsonWriter.PairExtractor<KeyValuePair> keyValuePairExtractor = JsonWriter.PairExtractor.of(pair -> pair.key, pair -> pair.value);

    ElasticCommonSchemaStructuredLogFormatter(Environment environment, ThrowableProxyConverter throwableProxyConverter) {
        super((JsonWriter.Members<E> members) -> ElasticCommonSchemaStructuredLogFormatter.jsonMembers(environment, throwableProxyConverter, members));
    }

    private static void jsonMembers(Environment environment, ThrowableProxyConverter throwableProxyConverter, JsonWriter.Members<ILoggingEvent> members) {
        members.add("@timestamp", ILoggingEvent::getInstant);
        members.add("log.level", ILoggingEvent::getLevel);
        members.add("process.pid", (Long)environment.getProperty("spring.application.pid", Long.class)).when(Objects::nonNull);
        members.add("process.thread.name", ILoggingEvent::getThreadName);
        ElasticCommonSchemaService.get(environment).jsonMembers(members);
        members.add("log.logger", ILoggingEvent::getLoggerName);
        members.add("message", ILoggingEvent::getFormattedMessage);
        members.addMapEntries(ILoggingEvent::getMDCPropertyMap);
        members.from(ILoggingEvent::getKeyValuePairs).whenNotEmpty().usingExtractedPairs(Iterable::forEach, keyValuePairExtractor);
        members.add().whenNotNull(ILoggingEvent::getThrowableProxy).usingMembers(throwableMembers -> {
            throwableMembers.add("error.type", ILoggingEvent::getThrowableProxy).as(IThrowableProxy::getClassName);
            throwableMembers.add("error.message", ILoggingEvent::getThrowableProxy).as(IThrowableProxy::getMessage);
            throwableMembers.add("error.stack_trace", arg_0 -> ((ThrowableProxyConverter)throwableProxyConverter).convert(arg_0));
        });
        members.add("ecs.version", "8.11");
    }
}

