/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.info;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import javax.security.auth.x500.X500Principal;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.util.ObjectUtils;

public class SslInfo {
    private final SslBundles sslBundles;
    private final Duration certificateValidityWarningThreshold;

    public SslInfo(SslBundles sslBundles, Duration certificateValidityWarningThreshold) {
        this.sslBundles = sslBundles;
        this.certificateValidityWarningThreshold = certificateValidityWarningThreshold;
    }

    public List<BundleInfo> getBundles() {
        return this.sslBundles.getBundleNames().stream().map(name -> new BundleInfo((String)name, this.sslBundles.getBundle((String)name))).toList();
    }

    public final class BundleInfo {
        private final String name;
        private final List<CertificateChainInfo> certificateChains;

        private BundleInfo(String name, SslBundle sslBundle) {
            this.name = name;
            this.certificateChains = this.extractCertificateChains(sslBundle.getStores().getKeyStore());
        }

        private List<CertificateChainInfo> extractCertificateChains(KeyStore keyStore) {
            try {
                return Collections.list(keyStore.aliases()).stream().map(alias -> new CertificateChainInfo(keyStore, (String)alias)).toList();
            }
            catch (KeyStoreException ex) {
                return Collections.emptyList();
            }
        }

        public String getName() {
            return this.name;
        }

        public List<CertificateChainInfo> getCertificateChains() {
            return this.certificateChains;
        }
    }

    public static class CertificateValidityInfo {
        static final CertificateValidityInfo VALID = new CertificateValidityInfo(Status.VALID, null, new Object[0]);
        private final Status status;
        private final String message;

        CertificateValidityInfo(Status status, String message, Object ... messageArgs) {
            this.status = status;
            this.message = message != null ? message.formatted(messageArgs) : null;
        }

        public Status getStatus() {
            return this.status;
        }

        public String getMessage() {
            return this.message;
        }

        public static enum Status {
            VALID(true),
            NOT_YET_VALID(false),
            EXPIRED(false),
            WILL_EXPIRE_SOON(true);

            private final boolean valid;

            private Status(boolean valid) {
                this.valid = valid;
            }

            public boolean isValid() {
                return this.valid;
            }
        }
    }

    public final class CertificateInfo {
        private final X509Certificate certificate;

        private CertificateInfo(Certificate certificate) {
            X509Certificate x509Certificate;
            this.certificate = certificate instanceof X509Certificate ? (x509Certificate = (X509Certificate)certificate) : null;
        }

        public String getSubject() {
            return this.extract(X509Certificate::getSubjectX500Principal, X500Principal::getName);
        }

        public String getIssuer() {
            return this.extract(X509Certificate::getIssuerX500Principal, X500Principal::getName);
        }

        public String getSerialNumber() {
            return this.extract(X509Certificate::getSerialNumber, serial -> serial.toString(16));
        }

        public String getVersion() {
            return this.extract(certificate -> "V" + certificate.getVersion());
        }

        public String getSignatureAlgorithmName() {
            return this.extract(X509Certificate::getSigAlgName);
        }

        public Instant getValidityStarts() {
            return this.extract(X509Certificate::getNotBefore, Date::toInstant);
        }

        public Instant getValidityEnds() {
            return this.extract(X509Certificate::getNotAfter, Date::toInstant);
        }

        public CertificateValidityInfo getValidity() {
            return this.extract(certificate -> {
                Instant starts = this.getValidityStarts();
                Instant ends = this.getValidityEnds();
                Duration threshold = SslInfo.this.certificateValidityWarningThreshold;
                try {
                    certificate.checkValidity();
                    return !this.isExpiringSoon((X509Certificate)certificate, threshold) ? CertificateValidityInfo.VALID : new CertificateValidityInfo(CertificateValidityInfo.Status.WILL_EXPIRE_SOON, "Certificate will expire within threshold (%s) at %s", threshold, ends);
                }
                catch (CertificateNotYetValidException ex) {
                    return new CertificateValidityInfo(CertificateValidityInfo.Status.NOT_YET_VALID, "Not valid before %s", starts);
                }
                catch (CertificateExpiredException ex) {
                    return new CertificateValidityInfo(CertificateValidityInfo.Status.EXPIRED, "Not valid after %s", ends);
                }
            });
        }

        private boolean isExpiringSoon(X509Certificate certificate, Duration threshold) {
            Instant shouldBeValidAt = Instant.now().plus(threshold);
            Instant expiresAt = certificate.getNotAfter().toInstant();
            return shouldBeValidAt.isAfter(expiresAt);
        }

        private <V, R> R extract(Function<X509Certificate, V> valueExtractor, Function<V, R> resultExtractor) {
            return this.extract(valueExtractor.andThen(resultExtractor));
        }

        private <R> R extract(Function<X509Certificate, R> extractor) {
            return this.certificate != null ? (R)extractor.apply(this.certificate) : null;
        }
    }

    public final class CertificateChainInfo {
        private final String alias;
        private final List<CertificateInfo> certificates;

        CertificateChainInfo(KeyStore keyStore, String alias) {
            this.alias = alias;
            this.certificates = this.extractCertificates(keyStore, alias);
        }

        private List<CertificateInfo> extractCertificates(KeyStore keyStore, String alias) {
            try {
                Object[] certificates = keyStore.getCertificateChain(alias);
                return !ObjectUtils.isEmpty((Object[])certificates) ? Arrays.stream(certificates).map(x$0 -> new CertificateInfo((Certificate)x$0)).toList() : Collections.emptyList();
            }
            catch (KeyStoreException ex) {
                return Collections.emptyList();
            }
        }

        public String getAlias() {
            return this.alias;
        }

        public List<CertificateInfo> getCertificates() {
            return this.certificates;
        }
    }
}

