/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.encoder.EncoderBase;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.boot.logging.logback.ElasticCommonSchemaStructuredLogFormatter;
import org.springframework.boot.logging.logback.LogstashStructuredLogFormatter;
import org.springframework.boot.logging.structured.ApplicationMetadata;
import org.springframework.boot.logging.structured.CommonStructuredLogFormat;
import org.springframework.boot.logging.structured.StructuredLogFormatter;
import org.springframework.boot.logging.structured.StructuredLogFormatterFactory;
import org.springframework.boot.util.Instantiator;
import org.springframework.util.Assert;

public class StructuredLogEncoder
extends EncoderBase<ILoggingEvent> {
    private final ThrowableProxyConverter throwableProxyConverter = new ThrowableProxyConverter();
    private String format;
    private StructuredLogFormatter<ILoggingEvent> formatter;
    private Long pid;
    private String serviceName;
    private String serviceVersion;
    private String serviceNodeName;
    private String serviceEnvironment;
    private Charset charset = StandardCharsets.UTF_8;

    public void setFormat(String format) {
        this.format = format;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public void setServiceNodeName(String serviceNodeName) {
        this.serviceNodeName = serviceNodeName;
    }

    public void setServiceEnvironment(String serviceEnvironment) {
        this.serviceEnvironment = serviceEnvironment;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void start() {
        Assert.state((this.format != null ? 1 : 0) != 0, (String)"Format has not been set");
        this.formatter = this.createFormatter(this.format);
        super.start();
        this.throwableProxyConverter.start();
    }

    private StructuredLogFormatter<ILoggingEvent> createFormatter(String format) {
        ApplicationMetadata applicationMetadata = new ApplicationMetadata(this.pid, this.serviceName, this.serviceVersion, this.serviceEnvironment, this.serviceNodeName);
        return new StructuredLogFormatterFactory<ILoggingEvent>(ILoggingEvent.class, applicationMetadata, this::addAvailableParameters, this::addCommonFormatters).get(format);
    }

    private void addAvailableParameters(Instantiator.AvailableParameters availableParameters) {
        availableParameters.add(ThrowableProxyConverter.class, this.throwableProxyConverter);
    }

    private void addCommonFormatters(StructuredLogFormatterFactory.CommonFormatters<ILoggingEvent> commonFormatters) {
        commonFormatters.add(CommonStructuredLogFormat.ELASTIC_COMMON_SCHEMA, instantiator -> new ElasticCommonSchemaStructuredLogFormatter(instantiator.getArg(ApplicationMetadata.class), instantiator.getArg(ThrowableProxyConverter.class)));
        commonFormatters.add(CommonStructuredLogFormat.LOGSTASH, instantiator -> new LogstashStructuredLogFormatter(instantiator.getArg(ThrowableProxyConverter.class)));
    }

    public void stop() {
        this.throwableProxyConverter.stop();
        super.stop();
    }

    public byte[] headerBytes() {
        return null;
    }

    public byte[] encode(ILoggingEvent event) {
        return this.formatter.format(event).getBytes(this.charset);
    }

    public byte[] footerBytes() {
        return null;
    }
}

