/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Marker;
import org.slf4j.event.KeyValuePair;
import org.springframework.boot.json.JsonWriter;
import org.springframework.boot.logging.structured.StructuredLogFormatter;

class LogstashStructuredLogFormatter
implements StructuredLogFormatter<ILoggingEvent> {
    private static final JsonWriter.PairExtractor<KeyValuePair> keyValuePairExtractor = JsonWriter.PairExtractor.of(pair -> pair.key, pair -> pair.value);
    private JsonWriter<ILoggingEvent> writer = JsonWriter.of(members -> this.loggingEventJson(throwableProxyConverter, (JsonWriter.Members<ILoggingEvent>)members)).withNewLineAtEnd();

    LogstashStructuredLogFormatter(ThrowableProxyConverter throwableProxyConverter) {
    }

    private void loggingEventJson(ThrowableProxyConverter throwableProxyConverter, JsonWriter.Members<ILoggingEvent> members) {
        members.add("@timestamp", ILoggingEvent::getInstant).as(this::asTimestamp);
        members.add("@version", "1");
        members.add("message", ILoggingEvent::getFormattedMessage);
        members.add("logger_name", ILoggingEvent::getLoggerName);
        members.add("thread_name", ILoggingEvent::getThreadName);
        members.add("level", ILoggingEvent::getLevel);
        members.add("level_value", ILoggingEvent::getLevel).as(Level::toInt);
        members.addMapEntries(ILoggingEvent::getMDCPropertyMap);
        members.add(ILoggingEvent::getKeyValuePairs).whenNotEmpty().usingExtractedPairs(Iterable::forEach, keyValuePairExtractor);
        members.add("tags", ILoggingEvent::getMarkerList).whenNotNull().as(this::getMarkers).whenNotEmpty();
        members.add("stack_trace", event -> event).whenNotNull(ILoggingEvent::getThrowableProxy).as(arg_0 -> ((ThrowableProxyConverter)throwableProxyConverter).convert(arg_0));
    }

    private String asTimestamp(Instant instant) {
        OffsetDateTime offsetDateTime = OffsetDateTime.ofInstant(instant, ZoneId.systemDefault());
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(offsetDateTime);
    }

    private Set<String> getMarkers(List<Marker> markers) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        this.addMarkers(result, markers.iterator());
        return result;
    }

    private void addMarkers(Set<String> result, Iterator<Marker> iterator) {
        while (iterator.hasNext()) {
            Marker marker = iterator.next();
            result.add(marker.getName());
            if (!marker.hasReferences()) continue;
            this.addMarkers(result, marker.iterator());
        }
    }

    @Override
    public String format(ILoggingEvent event) {
        return this.writer.writeToString(event);
    }
}

