/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.logback;

import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import org.slf4j.event.KeyValuePair;
import org.springframework.boot.json.JsonWriter;
import org.springframework.boot.logging.structured.ApplicationMetadata;
import org.springframework.boot.logging.structured.StructuredLogFormatter;

class ElasticCommonSchemaStructuredLogFormatter
implements StructuredLogFormatter<ILoggingEvent> {
    private static final JsonWriter.PairExtractor<KeyValuePair> keyValuePairExtractor = JsonWriter.PairExtractor.of(pair -> pair.key, pair -> pair.value);
    private JsonWriter<ILoggingEvent> writer = JsonWriter.of(members -> this.loggingEventJson(metadata, throwableProxyConverter, (JsonWriter.Members<ILoggingEvent>)members)).withNewLineAtEnd();

    ElasticCommonSchemaStructuredLogFormatter(ApplicationMetadata metadata, ThrowableProxyConverter throwableProxyConverter) {
    }

    private void loggingEventJson(ApplicationMetadata metadata, ThrowableProxyConverter throwableProxyConverter, JsonWriter.Members<ILoggingEvent> members) {
        members.add("@timestamp", ILoggingEvent::getInstant);
        members.add("log.level", ILoggingEvent::getLevel);
        members.add("process.pid", metadata::pid).whenNotNull();
        members.add("process.thread.name", ILoggingEvent::getThreadName);
        members.add("service.name", metadata::name).whenHasLength();
        members.add("service.version", metadata::version).whenHasLength();
        members.add("service.environment", metadata::environment).whenHasLength();
        members.add("service.node.name", metadata::nodeName).whenHasLength();
        members.add("log.logger", ILoggingEvent::getLoggerName);
        members.add("message", ILoggingEvent::getFormattedMessage);
        members.addMapEntries(ILoggingEvent::getMDCPropertyMap);
        members.add(ILoggingEvent::getKeyValuePairs).whenNotEmpty().usingExtractedPairs(Iterable::forEach, keyValuePairExtractor);
        members.addSelf().whenNotNull(ILoggingEvent::getThrowableProxy).usingMembers(throwableMembers -> {
            throwableMembers.add("error.type", ILoggingEvent::getThrowableProxy).as(IThrowableProxy::getClassName);
            throwableMembers.add("error.message", ILoggingEvent::getThrowableProxy).as(IThrowableProxy::getMessage);
            throwableMembers.add("error.stack_trace", event -> throwableProxyConverter.convert(event));
        });
        members.add("ecs.version", "8.11");
    }

    @Override
    public String format(ILoggingEvent event) {
        return this.writer.writeToString(event);
    }
}

