/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging.log4j2;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.springframework.boot.logging.log4j2.ElasticCommonSchemaStructuredLogFormatter;
import org.springframework.boot.logging.log4j2.LogstashStructuredLogFormatter;
import org.springframework.boot.logging.structured.ApplicationMetadata;
import org.springframework.boot.logging.structured.CommonStructuredLogFormat;
import org.springframework.boot.logging.structured.StructuredLogFormatter;
import org.springframework.boot.logging.structured.StructuredLogFormatterFactory;
import org.springframework.util.Assert;

@Plugin(name="StructuredLogLayout", category="Core", elementType="layout")
final class StructuredLogLayout
extends AbstractStringLayout {
    private final StructuredLogFormatter<LogEvent> formatter;

    private StructuredLogLayout(Charset charset, StructuredLogFormatter<LogEvent> formatter) {
        super(charset);
        Assert.notNull(formatter, (String)"Formatter must not be null");
        this.formatter = formatter;
    }

    public String toSerializable(LogEvent event) {
        return this.formatter.format(event);
    }

    @PluginBuilderFactory
    static Builder newBuilder() {
        return new Builder();
    }

    static final class Builder
    implements org.apache.logging.log4j.core.util.Builder<StructuredLogLayout> {
        @PluginBuilderAttribute
        private String format;
        @PluginBuilderAttribute
        private String charset = StandardCharsets.UTF_8.name();
        @PluginBuilderAttribute
        private Long pid;
        @PluginBuilderAttribute
        private String serviceName;
        @PluginBuilderAttribute
        private String serviceVersion;
        @PluginBuilderAttribute
        private String serviceNodeName;
        @PluginBuilderAttribute
        private String serviceEnvironment;

        Builder() {
        }

        Builder setFormat(String format) {
            this.format = format;
            return this;
        }

        Builder setCharset(String charset) {
            this.charset = charset;
            return this;
        }

        Builder setPid(Long pid) {
            this.pid = pid;
            return this;
        }

        Builder setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        Builder setServiceVersion(String serviceVersion) {
            this.serviceVersion = serviceVersion;
            return this;
        }

        Builder setServiceNodeName(String serviceNodeName) {
            this.serviceNodeName = serviceNodeName;
            return this;
        }

        Builder setServiceEnvironment(String serviceEnvironment) {
            this.serviceEnvironment = serviceEnvironment;
            return this;
        }

        public StructuredLogLayout build() {
            ApplicationMetadata applicationMetadata = new ApplicationMetadata(this.pid, this.serviceName, this.serviceVersion, this.serviceEnvironment, this.serviceNodeName);
            Charset charset = Charset.forName(this.charset);
            StructuredLogFormatter<LogEvent> formatter = new StructuredLogFormatterFactory<LogEvent>(LogEvent.class, applicationMetadata, null, this::addCommonFormatters).get(this.format);
            return new StructuredLogLayout(charset, formatter);
        }

        private void addCommonFormatters(StructuredLogFormatterFactory.CommonFormatters<LogEvent> commonFormatters) {
            commonFormatters.add(CommonStructuredLogFormat.ELASTIC_COMMON_SCHEMA, instantiator -> new ElasticCommonSchemaStructuredLogFormatter(instantiator.getArg(ApplicationMetadata.class)));
            commonFormatters.add(CommonStructuredLogFormat.LOGSTASH, instantiator -> new LogstashStructuredLogFormatter());
        }
    }
}

