/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.json;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.springframework.boot.json.JsonValueWriter;
import org.springframework.core.io.WritableResource;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@FunctionalInterface
public interface JsonWriter<T> {
    public void write(T var1, Appendable var2) throws IOException;

    default public String writeToString(T instance) {
        return this.write(instance).toJsonString();
    }

    default public WritableJson write(T instance) {
        return WritableJson.of((Appendable out) -> this.write(instance, out));
    }

    default public JsonWriter<T> withNewLineAtEnd() {
        return this.withSuffix("\n");
    }

    default public JsonWriter<T> withSuffix(String suffix) {
        if (!StringUtils.hasLength((String)suffix)) {
            return this;
        }
        return (instance, out) -> {
            this.write(instance, out);
            out.append(suffix);
        };
    }

    public static <T> JsonWriter<T> standard() {
        return JsonWriter.of(members -> members.addSelf());
    }

    public static <T> JsonWriter<T> of(Consumer<Members<T>> members) {
        Members initiaizedMembers = new Members(members, false);
        return (instance, out) -> initiaizedMembers.write(instance, new JsonValueWriter(out));
    }

    @FunctionalInterface
    public static interface WritableJson {
        public void to(Appendable var1) throws IOException;

        default public String toJsonString() {
            try {
                StringBuilder stringBuilder = new StringBuilder();
                this.to(stringBuilder);
                return stringBuilder.toString();
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        default public void toResource(WritableResource out) throws IOException {
            Assert.notNull((Object)out, (String)"'out' must not be null");
            try (OutputStream outputStream = out.getOutputStream();){
                this.toOutputStream(outputStream);
            }
        }

        default public void toResource(WritableResource out, Charset charset) throws IOException {
            Assert.notNull((Object)out, (String)"'out' must not be null");
            Assert.notNull((Object)charset, (String)"'charset' must not be null");
            try (OutputStream outputStream = out.getOutputStream();){
                this.toOutputStream(outputStream, charset);
            }
        }

        default public void toOutputStream(OutputStream out) throws IOException {
            this.toOutputStream(out, StandardCharsets.UTF_8);
        }

        default public void toOutputStream(OutputStream out, Charset charset) throws IOException {
            Assert.notNull((Object)out, (String)"'out' must not be null");
            Assert.notNull((Object)charset, (String)"'charset' must not be null");
            this.toWriter(new OutputStreamWriter(out, charset));
        }

        default public void toWriter(Writer out) throws IOException {
            Assert.notNull((Object)out, (String)"'out' must not be null");
            this.to(out);
            out.flush();
        }

        public static WritableJson of(final WritableJson writableJson) {
            return new WritableJson(){

                @Override
                public void to(Appendable out) throws IOException {
                    writableJson.to(out);
                }

                public String toString() {
                    return this.toJsonString();
                }
            };
        }
    }

    public static final class Members<T> {
        private final List<Member<?>> members = new ArrayList();
        private final boolean contributesPair;
        private final JsonValueWriter.Series series;

        Members(Consumer<Members<T>> members, boolean contributesToExistingSeries) {
            Assert.notNull(members, (String)"'members' must not be null");
            members.accept(this);
            Assert.state((!this.members.isEmpty() ? 1 : 0) != 0, (String)"No members have been added");
            this.contributesPair = this.members.stream().anyMatch(Member::contributesPair);
            JsonValueWriter.Series series = this.series = this.contributesPair && !contributesToExistingSeries ? JsonValueWriter.Series.OBJECT : null;
            if (this.contributesPair || this.members.size() > 1) {
                this.members.forEach(member -> Assert.state((boolean)member.contributesPair(), () -> String.format("%s does not contribute a named pair, ensure that all members have a name or call an appropriate 'using' method", member)));
            }
        }

        public Member<T> addSelf(String name) {
            return this.add(name, (T instance) -> instance);
        }

        public <V> Member<V> add(String name, V value) {
            return this.add(name, (T instance) -> value);
        }

        public <V> Member<V> add(String name, Supplier<V> supplier) {
            Assert.notNull(supplier, (String)"'supplier' must not be null");
            return this.add(name, (T instance) -> supplier.get());
        }

        public <V> Member<V> add(String name, Function<T, V> extractor) {
            Assert.notNull((Object)name, (String)"'name' must not be null");
            Assert.notNull(extractor, (String)"'extractor' must not be null");
            return this.addMember(name, extractor);
        }

        public Member<T> addSelf() {
            return this.add((T instance) -> instance);
        }

        public <V> Member<V> add(V value) {
            return this.add((T instance) -> value);
        }

        public <V> Member<V> add(Supplier<V> supplier) {
            Assert.notNull(supplier, (String)"'supplier' must not be null");
            return this.add((T instance) -> supplier.get());
        }

        public <V> Member<V> add(Function<T, V> extractor) {
            Assert.notNull(extractor, (String)"'extractor' must not be null");
            return this.addMember(null, extractor);
        }

        public <M extends Map<K, V>, K, V> Member<M> addMapEntries(Function<T, M> extractor) {
            return this.add(extractor).usingPairs(Map::forEach);
        }

        private <V> Member<V> addMember(String name, Function<T, V> extractor) {
            Member<V> member = new Member<V>(this.members.size(), name, Member.Extractor.of(extractor));
            this.members.add(member);
            return member;
        }

        void write(T instance, JsonValueWriter valueWriter) {
            valueWriter.start(this.series);
            for (Member<?> member : this.members) {
                member.write(instance, valueWriter);
            }
            valueWriter.end(this.series);
        }

        boolean contributesPair() {
            return this.contributesPair;
        }
    }

    public static final class Member<T> {
        private final int index;
        private final String name;
        private Extractor<T> extractor;
        private BiConsumer<T, BiConsumer<?, ?>> pairs;
        private Members<T> members;

        Member(int index, String name, Extractor<T> extractor) {
            this.index = index;
            this.name = name;
            this.extractor = extractor;
        }

        public Member<T> whenNotNull() {
            return this.when(Objects::nonNull);
        }

        public Member<T> whenNotNull(Function<T, ?> extractor) {
            Assert.notNull(extractor, (String)"'extractor' must not be null");
            return this.when(instance -> Objects.nonNull(extractor.apply(instance)));
        }

        public Member<T> whenHasLength() {
            return this.when(instance -> instance != null && StringUtils.hasLength((String)instance.toString()));
        }

        public Member<T> whenNotEmpty() {
            return this.whenNot(ObjectUtils::isEmpty);
        }

        public Member<T> whenNot(Predicate<T> predicate) {
            Assert.notNull(predicate, (String)"'predicate' must not be null");
            return this.when(predicate.negate());
        }

        public Member<T> when(Predicate<T> predicate) {
            Assert.notNull(predicate, (String)"'predicate' must not be null");
            this.extractor = this.extractor.when(predicate);
            return this;
        }

        public <R> Member<R> as(Function<T, R> adapter) {
            Assert.notNull(adapter, (String)"'adapter' must not be null");
            Member result = this;
            result.extractor = this.extractor.as(adapter);
            return result;
        }

        public <E, N, V> Member<T> usingExtractedPairs(BiConsumer<T, Consumer<E>> elements, PairExtractor<E> extractor) {
            Assert.notNull(elements, (String)"'elements' must not be null");
            Assert.notNull(extractor, (String)"'extractor' must not be null");
            return this.usingExtractedPairs(elements, extractor::getName, extractor::getValue);
        }

        public <E, N, V> Member<T> usingExtractedPairs(BiConsumer<T, Consumer<E>> elements, Function<E, N> nameExtractor, Function<E, V> valueExtractor) {
            Assert.notNull(elements, (String)"'elements' must not be null");
            Assert.notNull(nameExtractor, (String)"'nameExtractor' must not be null");
            Assert.notNull(valueExtractor, (String)"'valueExtractor' must not be null");
            return this.usingPairs((instance, pairsConsumer) -> elements.accept(instance, element -> {
                Object name = nameExtractor.apply(element);
                Object value = valueExtractor.apply(element);
                pairsConsumer.accept(name, value);
            }));
        }

        public <N, V> Member<T> usingPairs(BiConsumer<T, BiConsumer<N, V>> pairs) {
            Assert.notNull(pairs, (String)"'pairs' must not be null");
            Assert.state((this.pairs == null ? 1 : 0) != 0, (String)"Pairs cannot be declared multiple times");
            Assert.state((this.members == null ? 1 : 0) != 0, (String)"Pairs cannot be declared when using members");
            this.pairs = pairs;
            return this;
        }

        public Member<T> usingMembers(Consumer<Members<T>> members) {
            Assert.notNull(members, (String)"'members' must not be null");
            Assert.state((this.members == null ? 1 : 0) != 0, (String)"Members cannot be declared multiple times");
            Assert.state((this.pairs == null ? 1 : 0) != 0, (String)"Members cannot be declared when using pairs");
            this.members = new Members<T>(members, this.name == null);
            return this;
        }

        void write(Object instance, JsonValueWriter valueWriter) {
            T extracted = this.extractor.extract(instance);
            if (Extractor.skip(extracted)) {
                return;
            }
            Object value = this.getValueToWrite(extracted, valueWriter);
            valueWriter.write(this.name, value);
        }

        private Object getValueToWrite(T extracted, JsonValueWriter valueWriter) {
            if (this.pairs != null) {
                return WritableJson.of(out -> valueWriter.writePairs(pairs -> this.pairs.accept(extracted, (BiConsumer<?, ?>)pairs)));
            }
            if (this.members != null) {
                return WritableJson.of(out -> this.members.write(extracted, valueWriter));
            }
            return extracted;
        }

        boolean contributesPair() {
            return this.name != null || this.pairs != null || this.members != null && this.members.contributesPair();
        }

        public String toString() {
            return "Member at index " + this.index + (this.name != null ? "{%s}".formatted(this.name) : "");
        }

        @FunctionalInterface
        static interface Extractor<T> {
            public static final Object SKIP = new Object();

            public T extract(Object var1);

            default public Extractor<T> when(Predicate<T> predicate) {
                return instance -> this.test(this.extract(instance), predicate);
            }

            private T test(T extracted, Predicate<T> predicate) {
                return (T)(!Extractor.skip(extracted) && predicate.test(extracted) ? extracted : SKIP);
            }

            default public <R> Extractor<R> as(Function<T, R> adapter) {
                return instance -> this.apply(this.extract(instance), adapter);
            }

            private <R> R apply(T extracted, Function<T, R> function) {
                if (Extractor.skip(extracted)) {
                    return (R)SKIP;
                }
                return extracted != null ? (R)function.apply(extracted) : null;
            }

            public static <S, T> Extractor<T> of(Function<S, T> extractor) {
                return instance -> !Extractor.skip(instance) ? extractor.apply(instance) : SKIP;
            }

            public static <T> boolean skip(T extracted) {
                return extracted == SKIP;
            }
        }
    }

    public static interface PairExtractor<E> {
        public <N> N getName(E var1);

        public <V> V getValue(E var1);

        public static <T> PairExtractor<T> of(final Function<T, ?> nameExtractor, final Function<T, ?> valueExtractor) {
            Assert.notNull(nameExtractor, (String)"'nameExtractor' must not be null");
            Assert.notNull(valueExtractor, (String)"'valueExtractor' must not be null");
            return new PairExtractor<T>(){

                @Override
                public <N> N getName(T instance) {
                    return (N)nameExtractor.apply(instance);
                }

                @Override
                public <V> V getValue(T instance) {
                    return (V)valueExtractor.apply(instance);
                }
            };
        }
    }
}

