/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.json;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.springframework.boot.json.JsonWriter;
import org.springframework.util.ObjectUtils;
import org.springframework.util.function.ThrowingConsumer;

class JsonValueWriter {
    private final Appendable out;
    private final Deque<ActiveSeries> activeSeries = new ArrayDeque<ActiveSeries>();

    JsonValueWriter(Appendable out) {
        this.out = out;
    }

    <N, V> void write(N name, V value) {
        if (name != null) {
            this.writePair(name, value);
        } else {
            this.write(value);
        }
    }

    <V> void write(V value) {
        if (value == null) {
            this.append("null");
        } else if (value instanceof JsonWriter.WritableJson) {
            JsonWriter.WritableJson writableJson = (JsonWriter.WritableJson)value;
            try {
                writableJson.to(this.out);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        } else if (value instanceof Iterable) {
            Iterable iterable = (Iterable)value;
            this.writeArray(iterable::forEach);
        } else if (ObjectUtils.isArray(value)) {
            this.writeArray(Arrays.asList(ObjectUtils.toObjectArray(value))::forEach);
        } else if (value instanceof Map) {
            Map map = (Map)value;
            this.writeObject(map::forEach);
        } else if (value instanceof Number) {
            this.append(value.toString());
        } else if (value instanceof Boolean) {
            this.append(Boolean.TRUE.equals(value) ? "true" : "false");
        } else {
            this.writeString(value);
        }
    }

    void start(Series series) {
        if (series != null) {
            this.activeSeries.push(new ActiveSeries());
            this.append(series.openChar);
        }
    }

    void end(Series series) {
        if (series != null) {
            this.activeSeries.pop();
            this.append(series.closeChar);
        }
    }

    <E> void writeArray(Consumer<Consumer<E>> elements) {
        this.start(Series.ARRAY);
        elements.accept((Consumer<E>)ThrowingConsumer.of(this::writeElement));
        this.end(Series.ARRAY);
    }

    <E> void writeElements(Consumer<Consumer<E>> elements) {
        elements.accept((Consumer<E>)ThrowingConsumer.of(this::writeElement));
    }

    <E> void writeElement(E element) {
        ActiveSeries activeSeries = this.activeSeries.peek();
        activeSeries.appendCommaIfRequired();
        this.write(element);
    }

    <N, V> void writeObject(Consumer<BiConsumer<N, V>> pairs) {
        this.start(Series.OBJECT);
        pairs.accept(this::writePair);
        this.end(Series.OBJECT);
    }

    <N, V> void writePairs(Consumer<BiConsumer<N, V>> pairs) {
        pairs.accept(this::writePair);
    }

    private <N, V> void writePair(N name, V value) {
        ActiveSeries activeSeries = this.activeSeries.peek();
        activeSeries.appendCommaIfRequired();
        this.writeString(name);
        this.append(":");
        this.write(value);
    }

    private void writeString(Object value) {
        try {
            this.out.append('\"');
            String string = value.toString();
            block12: for (int i = 0; i < string.length(); ++i) {
                char ch = string.charAt(i);
                switch (ch) {
                    case '\"': {
                        this.out.append("\\\"");
                        continue block12;
                    }
                    case '\\': {
                        this.out.append("\\\\");
                        continue block12;
                    }
                    case '/': {
                        this.out.append("\\/");
                        continue block12;
                    }
                    case '\b': {
                        this.out.append("\\b");
                        continue block12;
                    }
                    case '\f': {
                        this.out.append("\\f");
                        continue block12;
                    }
                    case '\n': {
                        this.out.append("\\n");
                        continue block12;
                    }
                    case '\r': {
                        this.out.append("\\r");
                        continue block12;
                    }
                    case '\t': {
                        this.out.append("\\t");
                        continue block12;
                    }
                    default: {
                        if (Character.isISOControl(ch)) {
                            this.out.append("\\u");
                            this.out.append(String.format("%04X", ch));
                            continue block12;
                        }
                        this.out.append(ch);
                    }
                }
            }
            this.out.append('\"');
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private void append(String value) {
        try {
            this.out.append(value);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private void append(char ch) {
        try {
            this.out.append(ch);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private final class ActiveSeries {
        private boolean commaRequired;

        private ActiveSeries() {
        }

        void appendCommaIfRequired() {
            if (this.commaRequired) {
                JsonValueWriter.this.append(',');
            }
            this.commaRequired = true;
        }
    }

    static enum Series {
        OBJECT('{', '}'),
        ARRAY('[', ']');

        final char openChar;
        final char closeChar;

        private Series(char openChar, char closeChar) {
            this.openChar = openChar;
            this.closeChar = closeChar;
        }
    }
}

