/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jms;

import jakarta.jms.ConnectionFactory;
import org.messaginghub.pooled.jms.JmsPoolConnectionFactory;
import org.springframework.jms.connection.CachingConnectionFactory;

public abstract class ConnectionFactoryUnwrapper {
    public static ConnectionFactory unwrap(ConnectionFactory connectionFactory) {
        if (connectionFactory instanceof CachingConnectionFactory) {
            CachingConnectionFactory ccf = (CachingConnectionFactory)connectionFactory;
            return ConnectionFactoryUnwrapper.unwrap(ccf.getTargetConnectionFactory());
        }
        ConnectionFactory unwrapedConnectionFactory = ConnectionFactoryUnwrapper.unwrapFromJmsPoolConnectionFactory(connectionFactory);
        return unwrapedConnectionFactory != null ? ConnectionFactoryUnwrapper.unwrap(unwrapedConnectionFactory) : connectionFactory;
    }

    private static ConnectionFactory unwrapFromJmsPoolConnectionFactory(ConnectionFactory connectionFactory) {
        try {
            if (connectionFactory instanceof JmsPoolConnectionFactory) {
                JmsPoolConnectionFactory poolConnectionFactory = (JmsPoolConnectionFactory)connectionFactory;
                return (ConnectionFactory)poolConnectionFactory.getConnectionFactory();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

