/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public interface SslOptions {
    public static final SslOptions NONE = SslOptions.of((Set<String>)null, (Set<String>)null);

    public Set<String> getCiphers();

    public Set<String> getEnabledProtocols();

    public static SslOptions of(String[] ciphers, String[] enabledProtocols) {
        return SslOptions.of(SslOptions.asSet(ciphers), SslOptions.asSet(enabledProtocols));
    }

    public static SslOptions of(final Set<String> ciphers, final Set<String> enabledProtocols) {
        return new SslOptions(){

            @Override
            public Set<String> getCiphers() {
                return ciphers;
            }

            @Override
            public Set<String> getEnabledProtocols() {
                return enabledProtocols;
            }
        };
    }

    private static Set<String> asSet(String[] array) {
        return array != null ? Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(array))) : null;
    }
}

