/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.client;

import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.util.function.Consumer;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeHint;
import org.springframework.aot.hint.TypeReference;
import org.springframework.http.client.AbstractClientHttpRequestFactoryWrapper;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

class ClientHttpRequestFactoriesRuntimeHints
implements RuntimeHintsRegistrar {
    ClientHttpRequestFactoriesRuntimeHints() {
    }

    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        if (ClassUtils.isPresent((String)"org.springframework.http.client.ClientHttpRequestFactory", (ClassLoader)classLoader)) {
            this.registerHints(hints.reflection(), classLoader);
        }
    }

    private void registerHints(ReflectionHints hints, ClassLoader classLoader) {
        hints.registerField(this.findField(AbstractClientHttpRequestFactoryWrapper.class, "requestFactory"));
        if (ClassUtils.isPresent((String)"org.apache.hc.client5.http.impl.classic.HttpClients", (ClassLoader)classLoader)) {
            this.registerReflectionHints(hints, HttpComponentsClientHttpRequestFactory.class, this::onReachableHttpClient);
        }
        if (ClassUtils.isPresent((String)"okhttp3.OkHttpClient", (ClassLoader)classLoader)) {
            this.registerReflectionHints(hints, OkHttp3ClientHttpRequestFactory.class, this::onReachableOkHttpClient);
        }
        this.registerReflectionHints(hints, SimpleClientHttpRequestFactory.class, this::onReachableHttpUrlConnection);
    }

    private void onReachableHttpUrlConnection(TypeHint.Builder typeHint) {
        typeHint.onReachableType(HttpURLConnection.class);
    }

    private void onReachableHttpClient(TypeHint.Builder typeHint) {
        typeHint.onReachableType(TypeReference.of((String)"org.apache.hc.client5.http.impl.classic.HttpClients"));
    }

    private void onReachableOkHttpClient(TypeHint.Builder typeHint) {
        typeHint.onReachableType(TypeReference.of((String)"okhttp3.OkHttpClient"));
    }

    private void registerReflectionHints(ReflectionHints hints, Class<? extends ClientHttpRequestFactory> requestFactoryType, Consumer<TypeHint.Builder> hintCustomizer) {
        hints.registerType(requestFactoryType, typeHint -> {
            typeHint.withMethod("setConnectTimeout", TypeReference.listOf((Class[])new Class[]{Integer.TYPE}), ExecutableMode.INVOKE);
            typeHint.withMethod("setReadTimeout", TypeReference.listOf((Class[])new Class[]{Integer.TYPE}), ExecutableMode.INVOKE);
            typeHint.withMethod("setBufferRequestBody", TypeReference.listOf((Class[])new Class[]{Boolean.TYPE}), ExecutableMode.INVOKE);
            hintCustomizer.accept((TypeHint.Builder)typeHint);
        });
    }

    private Field findField(Class<?> type, String name) {
        Field field = ReflectionUtils.findField(type, (String)name);
        Assert.state((field != null ? 1 : 0) != 0, () -> "Unable to find field '%s' on %s".formatted(type.getName(), name));
        return field;
    }
}

