/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.beans.BeanInfoFactory;
import org.springframework.beans.ExtendedBeanInfoFactory;
import org.springframework.boot.context.properties.bind.BindConstructorProvider;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Nested;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class BindableRuntimeHintsRegistrar
implements RuntimeHintsRegistrar {
    private static final BeanInfoFactory beanInfoFactory = new ExtendedBeanInfoFactory();
    private final Class<?>[] types;

    protected BindableRuntimeHintsRegistrar(Class<?> ... types) {
        this.types = types;
    }

    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        this.registerHints(hints);
    }

    public void registerHints(RuntimeHints hints) {
        for (Class<?> type : this.types) {
            new Processor(type).process(hints.reflection());
        }
    }

    public static BindableRuntimeHintsRegistrar forTypes(Iterable<Class<?>> types) {
        Assert.notNull(types, (String)"Types must not be null");
        return BindableRuntimeHintsRegistrar.forTypes((Class[])StreamSupport.stream(types.spliterator(), false).toArray(Class[]::new));
    }

    public static BindableRuntimeHintsRegistrar forTypes(Class<?> ... types) {
        return new BindableRuntimeHintsRegistrar(types);
    }

    private final class Processor {
        private final Class<?> type;
        private final Constructor<?> bindConstructor;
        private final BeanInfo beanInfo;
        private final Set<Class<?>> seen;

        Processor(Class<?> type) {
            this(type, false, new HashSet());
        }

        private Processor(Class<?> type, boolean nestedType, Set<Class<?>> seen) {
            this.type = type;
            this.bindConstructor = BindConstructorProvider.DEFAULT.getBindConstructor(Bindable.of(type), nestedType);
            this.beanInfo = Processor.getBeanInfo(type);
            this.seen = seen;
        }

        private static BeanInfo getBeanInfo(Class<?> beanType) {
            try {
                BeanInfo beanInfo = beanInfoFactory.getBeanInfo(beanType);
                if (beanInfo != null) {
                    return beanInfo;
                }
                return Introspector.getBeanInfo(beanType, 3);
            }
            catch (IntrospectionException ex) {
                return null;
            }
        }

        void process(ReflectionHints hints) {
            if (this.seen.contains(this.type)) {
                return;
            }
            this.seen.add(this.type);
            this.handleConstructor(hints);
            if (this.bindConstructor != null) {
                this.handleValueObjectProperties(hints);
            } else if (this.beanInfo != null) {
                this.handleJavaBeanProperties(hints);
            }
        }

        private void handleConstructor(ReflectionHints hints) {
            if (this.bindConstructor != null) {
                hints.registerConstructor(this.bindConstructor, ExecutableMode.INVOKE);
                return;
            }
            Arrays.stream(this.type.getDeclaredConstructors()).filter(this::hasNoParameters).findFirst().ifPresent(constructor -> hints.registerConstructor(constructor, ExecutableMode.INVOKE));
        }

        private boolean hasNoParameters(Constructor<?> candidate) {
            return candidate.getParameterCount() == 0;
        }

        private void handleValueObjectProperties(ReflectionHints hints) {
            for (int i = 0; i < this.bindConstructor.getParameterCount(); ++i) {
                String propertyName = this.bindConstructor.getParameters()[i].getName();
                ResolvableType propertyType = ResolvableType.forConstructorParameter(this.bindConstructor, (int)i);
                this.handleProperty(hints, propertyName, propertyType);
            }
        }

        private void handleJavaBeanProperties(ReflectionHints hints) {
            for (PropertyDescriptor propertyDescriptor : this.beanInfo.getPropertyDescriptors()) {
                Method readMethod;
                Method writeMethod = propertyDescriptor.getWriteMethod();
                if (writeMethod != null) {
                    hints.registerMethod(writeMethod, ExecutableMode.INVOKE);
                }
                if ((readMethod = propertyDescriptor.getReadMethod()) == null) continue;
                ResolvableType propertyType = ResolvableType.forMethodReturnType((Method)readMethod, this.type);
                String propertyName = propertyDescriptor.getName();
                if (this.isSetterMandatory(propertyName, propertyType) && writeMethod == null) continue;
                this.handleProperty(hints, propertyName, propertyType);
                hints.registerMethod(readMethod, ExecutableMode.INVOKE);
            }
        }

        private boolean isSetterMandatory(String propertyName, ResolvableType propertyType) {
            Class propertyClass = propertyType.resolve();
            if (propertyClass == null) {
                return true;
            }
            if (this.isContainer(propertyType)) {
                return false;
            }
            return !this.isNestedType(propertyName, propertyClass);
        }

        private void handleProperty(ReflectionHints hints, String propertyName, ResolvableType propertyType) {
            Class propertyClass = propertyType.resolve();
            if (propertyClass == null) {
                return;
            }
            if (propertyClass.equals(this.type)) {
                return;
            }
            Class<?> componentType = this.getComponentClass(propertyType);
            if (componentType != null) {
                if (!this.isJavaType(componentType)) {
                    this.processNested(componentType, hints);
                }
            } else if (this.isNestedType(propertyName, propertyClass)) {
                this.processNested(propertyClass, hints);
            }
        }

        private void processNested(Class<?> type, ReflectionHints hints) {
            new Processor(type, true, this.seen).process(hints);
        }

        private Class<?> getComponentClass(ResolvableType type) {
            ResolvableType componentType = this.getComponentType(type);
            if (componentType == null) {
                return null;
            }
            if (this.isContainer(componentType)) {
                return this.getComponentClass(componentType);
            }
            return componentType.toClass();
        }

        private ResolvableType getComponentType(ResolvableType type) {
            if (type.isArray()) {
                return type.getComponentType();
            }
            if (this.isCollection(type)) {
                return type.asCollection().getGeneric(new int[0]);
            }
            if (this.isMap(type)) {
                return type.asMap().getGeneric(new int[]{1});
            }
            return null;
        }

        private boolean isContainer(ResolvableType type) {
            return type.isArray() || this.isCollection(type) || this.isMap(type);
        }

        private boolean isCollection(ResolvableType type) {
            return Collection.class.isAssignableFrom(type.toClass());
        }

        private boolean isMap(ResolvableType type) {
            return Map.class.isAssignableFrom(type.toClass());
        }

        private boolean isNestedType(String propertyName, Class<?> propertyType) {
            if (this.type.equals(propertyType.getDeclaringClass())) {
                return true;
            }
            Field field = ReflectionUtils.findField(this.type, (String)propertyName);
            return field != null && MergedAnnotations.from((AnnotatedElement)field).isPresent(Nested.class);
        }

        private boolean isJavaType(Class<?> candidate) {
            return candidate.getPackageName().startsWith("java.");
        }
    }
}

