/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.json;

import com.fasterxml.jackson.databind.ser.std.ClassSerializer;
import com.fasterxml.jackson.databind.ser.std.FileSerializer;
import com.fasterxml.jackson.databind.ser.std.StdJdkSerializers;
import com.fasterxml.jackson.databind.ser.std.TokenBufferSerializer;
import java.util.stream.Stream;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.util.ClassUtils;

class JacksonRuntimeHints
implements RuntimeHintsRegistrar {
    JacksonRuntimeHints() {
    }

    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        if (!ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ser.BasicSerializerFactory", (ClassLoader)classLoader)) {
            return;
        }
        this.registerSerializers(hints.reflection());
    }

    private void registerSerializers(ReflectionHints hints) {
        Stream.of(StdJdkSerializers.AtomicBooleanSerializer.class, StdJdkSerializers.AtomicIntegerSerializer.class, StdJdkSerializers.AtomicLongSerializer.class, FileSerializer.class, ClassSerializer.class, TokenBufferSerializer.class).forEach(type -> hints.registerType(type, hint -> hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS})));
    }
}

