/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.util.ArrayList;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.support.RuntimeHintsUtils;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesReflectionHintsProcessor;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

class ConfigurationPropertiesBeanFactoryInitializationAotProcessor
implements BeanFactoryInitializationAotProcessor {
    ConfigurationPropertiesBeanFactoryInitializationAotProcessor() {
    }

    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        String[] beanNames = beanFactory.getBeanNamesForAnnotation(ConfigurationProperties.class);
        ArrayList types = new ArrayList();
        for (String beanName : beanNames) {
            Class beanType = beanFactory.getType(beanName, false);
            if (beanType == null) continue;
            types.add(ClassUtils.getUserClass((Class)beanType));
        }
        if (!CollectionUtils.isEmpty(types)) {
            return new ConfigurationPropertiesReflectionHintsContribution(types);
        }
        return null;
    }

    private static final class ConfigurationPropertiesReflectionHintsContribution
    implements BeanFactoryInitializationAotContribution {
        private final Iterable<Class<?>> types;

        private ConfigurationPropertiesReflectionHintsContribution(Iterable<Class<?>> types) {
            this.types = types;
        }

        public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
            RuntimeHintsUtils.registerAnnotation((RuntimeHints)generationContext.getRuntimeHints(), ConfigurationProperties.class);
            for (Class<?> type : this.types) {
                ConfigurationPropertiesReflectionHintsProcessor.processConfigurationProperties(type, generationContext.getRuntimeHints().reflection());
            }
        }
    }
}

