/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConstructorBinding;
import org.springframework.boot.context.properties.bind.BindConstructorProvider;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.Assert;

public class ConfigurationPropertiesBindConstructorProvider
implements BindConstructorProvider {
    public static final ConfigurationPropertiesBindConstructorProvider INSTANCE = new ConfigurationPropertiesBindConstructorProvider();

    @Override
    public Constructor<?> getBindConstructor(Bindable<?> bindable, boolean isNestedConstructorBinding) {
        return this.getBindConstructor(bindable.getType().resolve(), isNestedConstructorBinding);
    }

    Constructor<?> getBindConstructor(Class<?> type, boolean isNestedConstructorBinding) {
        if (type == null) {
            return null;
        }
        Constructors constructors = Constructors.getConstructors(type);
        if (constructors.getBind() != null || isNestedConstructorBinding) {
            Assert.state((!constructors.hasAutowired() ? 1 : 0) != 0, () -> type.getName() + " declares @ConstructorBinding and @Autowired constructor");
        }
        return constructors.getBind();
    }

    static final class Constructors {
        private final boolean hasAutowired;
        private final Constructor<?> bind;

        private Constructors(boolean hasAutowired, Constructor<?> bind) {
            this.hasAutowired = hasAutowired;
            this.bind = bind;
        }

        boolean hasAutowired() {
            return this.hasAutowired;
        }

        Constructor<?> getBind() {
            return this.bind;
        }

        static Constructors getConstructors(Class<?> type) {
            Constructor<?>[] candidates = Constructors.getCandidateConstructors(type);
            Constructor<?> deducedBind = Constructors.deduceBindConstructor(candidates);
            if (deducedBind != null) {
                return new Constructors(false, deducedBind);
            }
            boolean hasAutowiredConstructor = false;
            Constructor<?> bind = null;
            for (Constructor<?> candidate : candidates) {
                if (Constructors.isAutowired(candidate)) {
                    hasAutowiredConstructor = true;
                    continue;
                }
                bind = Constructors.findAnnotatedConstructor(type, bind, candidate);
            }
            return new Constructors(hasAutowiredConstructor, bind);
        }

        private static Constructor<?>[] getCandidateConstructors(Class<?> type) {
            if (Constructors.isInnerClass(type)) {
                return new Constructor[0];
            }
            return (Constructor[])Arrays.stream(type.getDeclaredConstructors()).filter(constructor -> Constructors.isNonSynthetic(constructor, type)).toArray(Constructor[]::new);
        }

        private static boolean isInnerClass(Class<?> type) {
            try {
                return type.getDeclaredField("this$0").isSynthetic();
            }
            catch (NoSuchFieldException ex) {
                return false;
            }
        }

        private static boolean isNonSynthetic(Constructor<?> constructor, Class<?> type) {
            return !constructor.isSynthetic();
        }

        private static Constructor<?> deduceBindConstructor(Constructor<?>[] constructors) {
            if (constructors.length == 1 && constructors[0].getParameterCount() > 0 && !Constructors.isAutowired(constructors[0])) {
                return constructors[0];
            }
            return null;
        }

        private static boolean isAutowired(Constructor<?> candidate) {
            return MergedAnnotations.from(candidate).isPresent(Autowired.class);
        }

        private static Constructor<?> findAnnotatedConstructor(Class<?> type, Constructor<?> constructor, Constructor<?> candidate) {
            if (MergedAnnotations.from(candidate).isPresent(ConstructorBinding.class)) {
                Assert.state((candidate.getParameterCount() > 0 ? 1 : 0) != 0, () -> type.getName() + " declares @ConstructorBinding on a no-args constructor");
                Assert.state((constructor == null ? 1 : 0) != 0, () -> type.getName() + " has more than one @ConstructorBinding constructor");
                constructor = candidate;
            }
            return constructor;
        }
    }
}

