/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.BeanInfoFactory;
import org.springframework.beans.ExtendedBeanInfoFactory;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanFactoryInitializationCode;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationPropertiesBindConstructorProvider;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

class ConfigurationPropertiesBeanFactoryInitializationAotProcessor
implements BeanFactoryInitializationAotProcessor {
    ConfigurationPropertiesBeanFactoryInitializationAotProcessor() {
    }

    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        String[] beanNames = beanFactory.getBeanNamesForAnnotation(ConfigurationProperties.class);
        ArrayList types = new ArrayList();
        for (String beanName : beanNames) {
            BeanDefinition beanDefinition = beanFactory.getMergedBeanDefinition(beanName);
            types.add(ClassUtils.getUserClass((Class)beanDefinition.getResolvableType().toClass()));
        }
        if (!CollectionUtils.isEmpty(types)) {
            return new ConfigurationPropertiesReflectionHintsContribution(types);
        }
        return null;
    }

    private static final class ConfigurationPropertiesReflectionHintsContribution
    implements BeanFactoryInitializationAotContribution {
        private final Iterable<Class<?>> types;

        private ConfigurationPropertiesReflectionHintsContribution(Iterable<Class<?>> types) {
            this.types = types;
        }

        public void applyTo(GenerationContext generationContext, BeanFactoryInitializationCode beanFactoryInitializationCode) {
            for (Class<?> type : this.types) {
                TypeProcessor.processConfigurationProperties(type, generationContext.getRuntimeHints());
            }
        }
    }

    private static final class TypeProcessor {
        private static final BeanInfoFactory beanInfoFactory = new ExtendedBeanInfoFactory();
        private final Class<?> type;
        private final Constructor<?> bindConstructor;
        private final BeanInfo beanInfo;
        private final Set<Class<?>> seen;

        private TypeProcessor(Class<?> type, Constructor<?> bindConstructor, Set<Class<?>> seen) {
            this.type = type;
            this.bindConstructor = bindConstructor;
            this.beanInfo = TypeProcessor.getBeanInfo(type);
            this.seen = seen;
        }

        private static void processConfigurationProperties(Class<?> type, RuntimeHints runtimeHints) {
            new TypeProcessor(type, TypeProcessor.getBindConstructor(type, false), new HashSet()).process(runtimeHints);
        }

        private void processNestedType(Class<?> type, RuntimeHints runtimeHints) {
            this.processNestedType(type, TypeProcessor.getBindConstructor(type, true), runtimeHints);
        }

        private void processNestedType(Class<?> type, Constructor<?> bindConstructor, RuntimeHints runtimeHints) {
            new TypeProcessor(type, bindConstructor, this.seen).process(runtimeHints);
        }

        private static Constructor<?> getBindConstructor(Class<?> type, boolean nestedType) {
            Bindable<?> bindable = Bindable.of(type);
            return ConfigurationPropertiesBindConstructorProvider.INSTANCE.getBindConstructor(bindable, nestedType);
        }

        private void process(RuntimeHints runtimeHints) {
            if (this.seen.contains(this.type)) {
                return;
            }
            this.seen.add(this.type);
            runtimeHints.reflection().registerType(this.type, hint -> hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_PUBLIC_METHODS}));
            this.handleConstructor(runtimeHints);
            if (this.bindConstructor != null) {
                this.handleValueObjectProperties(runtimeHints);
            } else if (this.beanInfo != null) {
                this.handleJavaBeanProperties(runtimeHints);
            }
        }

        private void handleConstructor(RuntimeHints runtimeHints) {
            if (this.bindConstructor != null) {
                runtimeHints.reflection().registerConstructor(this.bindConstructor);
            } else {
                Arrays.stream(this.type.getDeclaredConstructors()).filter(candidate -> candidate.getParameterCount() == 0).findFirst().ifPresent(constructor -> runtimeHints.reflection().registerConstructor(constructor));
            }
        }

        private void handleValueObjectProperties(RuntimeHints runtimeHints) {
            for (int i = 0; i < this.bindConstructor.getParameterCount(); ++i) {
                String propertyName = this.bindConstructor.getParameters()[i].getName();
                ResolvableType propertyType = ResolvableType.forConstructorParameter(this.bindConstructor, (int)i);
                this.handleProperty(runtimeHints, propertyName, propertyType);
            }
        }

        private void handleJavaBeanProperties(RuntimeHints runtimeHints) {
            for (PropertyDescriptor propertyDescriptor : this.beanInfo.getPropertyDescriptors()) {
                Method readMethod = propertyDescriptor.getReadMethod();
                if (readMethod == null) continue;
                ResolvableType propertyType = ResolvableType.forMethodReturnType((Method)readMethod, this.type);
                String propertyName = propertyDescriptor.getName();
                if (this.isSetterMandatory(propertyName, propertyType) && propertyDescriptor.getWriteMethod() == null) continue;
                this.handleProperty(runtimeHints, propertyName, propertyType);
            }
        }

        private void handleProperty(RuntimeHints runtimeHints, String propertyName, ResolvableType propertyType) {
            Class propertyClass = propertyType.resolve();
            if (propertyClass == null) {
                return;
            }
            if (propertyClass.equals(this.type)) {
                return;
            }
            Class<?> componentType = this.getComponentType(propertyType);
            if (componentType != null) {
                if (!this.isJavaType(componentType)) {
                    this.processNestedType(componentType, runtimeHints);
                }
            } else if (this.isNestedType(propertyName, propertyClass)) {
                this.processNestedType(propertyClass, runtimeHints);
            }
        }

        private boolean isSetterMandatory(String propertyName, ResolvableType propertyType) {
            Class propertyClass = propertyType.resolve();
            if (propertyClass == null) {
                return true;
            }
            if (this.getComponentType(propertyType) != null) {
                return false;
            }
            return !this.isNestedType(propertyName, propertyClass);
        }

        private Class<?> getComponentType(ResolvableType propertyType) {
            Class propertyClass = propertyType.toClass();
            if (propertyType.isArray()) {
                return propertyType.getComponentType().toClass();
            }
            if (Collection.class.isAssignableFrom(propertyClass)) {
                return propertyType.as(Collection.class).getGeneric(new int[]{0}).toClass();
            }
            if (Map.class.isAssignableFrom(propertyClass)) {
                return propertyType.as(Map.class).getGeneric(new int[]{1}).toClass();
            }
            return null;
        }

        private boolean isNestedType(String propertyName, Class<?> propertyType) {
            if (this.type.equals(propertyType.getDeclaringClass())) {
                return true;
            }
            Field field = ReflectionUtils.findField(this.type, (String)propertyName);
            return field != null && MergedAnnotations.from((AnnotatedElement)field).isPresent(NestedConfigurationProperty.class);
        }

        private boolean isJavaType(Class<?> candidate) {
            return candidate.getPackageName().startsWith("java.");
        }

        private static BeanInfo getBeanInfo(Class<?> beanType) {
            try {
                BeanInfo beanInfo = beanInfoFactory.getBeanInfo(beanType);
                if (beanInfo != null) {
                    return beanInfo;
                }
                return Introspector.getBeanInfo(beanType, 3);
            }
            catch (IntrospectionException ex) {
                return null;
            }
        }
    }
}

