/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc;

import io.r2dbc.spi.ConnectionFactories;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import java.util.function.Consumer;
import org.springframework.util.Assert;

public final class ConnectionFactoryBuilder {
    private final ConnectionFactoryOptions.Builder optionsBuilder;

    private ConnectionFactoryBuilder(ConnectionFactoryOptions.Builder optionsBuilder) {
        this.optionsBuilder = optionsBuilder;
    }

    public static ConnectionFactoryBuilder withUrl(String url) {
        Assert.hasText((String)url, () -> "Url must not be null");
        return ConnectionFactoryBuilder.withOptions(ConnectionFactoryOptions.parse((CharSequence)url).mutate());
    }

    public static ConnectionFactoryBuilder withOptions(ConnectionFactoryOptions.Builder options) {
        return new ConnectionFactoryBuilder(options);
    }

    public ConnectionFactoryBuilder configure(Consumer<ConnectionFactoryOptions.Builder> options) {
        options.accept(this.optionsBuilder);
        return this;
    }

    public ConnectionFactoryBuilder username(String username) {
        return this.configure(options -> options.option(ConnectionFactoryOptions.USER, (Object)username));
    }

    public ConnectionFactoryBuilder password(CharSequence password) {
        return this.configure(options -> options.option(ConnectionFactoryOptions.PASSWORD, (Object)password));
    }

    public ConnectionFactoryBuilder hostname(String host) {
        return this.configure(options -> options.option(ConnectionFactoryOptions.HOST, (Object)host));
    }

    public ConnectionFactoryBuilder port(int port) {
        return this.configure(options -> options.option(ConnectionFactoryOptions.PORT, (Object)port));
    }

    public ConnectionFactoryBuilder database(String database) {
        return this.configure(options -> options.option(ConnectionFactoryOptions.DATABASE, (Object)database));
    }

    public ConnectionFactory build() {
        return ConnectionFactories.get((ConnectionFactoryOptions)this.buildOptions());
    }

    public ConnectionFactoryOptions buildOptions() {
        return this.optionsBuilder.build();
    }
}

