/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.init;

import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.jdbc.init.DependsOnDataSourceInitialization;
import org.springframework.boot.jdbc.init.DependsOnDataSourceInitializationDetector;

class AnnotationDependsOnDataSourceInitializationDetector
implements DependsOnDataSourceInitializationDetector {
    AnnotationDependsOnDataSourceInitializationDetector() {
    }

    @Override
    public Set<String> detect(ConfigurableListableBeanFactory beanFactory) {
        HashSet<String> dependentBeans = new HashSet<String>();
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            if (beanFactory.findAnnotationOnBean(beanName, DependsOnDataSourceInitialization.class) == null) continue;
            dependentBeans.add(beanName);
        }
        return dependentBeans;
    }
}

