/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.init;

import java.util.Collections;
import java.util.Set;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.jdbc.init.BeansOfTypeDetector;
import org.springframework.boot.jdbc.init.DependsOnDataSourceInitializationDetector;

public abstract class AbstractBeansOfTypeDependsOnDataSourceInitializationDetector
implements DependsOnDataSourceInitializationDetector {
    protected abstract Set<Class<?>> getDependsOnDataSourceInitializationBeanTypes();

    @Override
    public Set<String> detect(ConfigurableListableBeanFactory beanFactory) {
        try {
            Set<Class<?>> types = this.getDependsOnDataSourceInitializationBeanTypes();
            return new BeansOfTypeDetector(types).detect((ListableBeanFactory)beanFactory);
        }
        catch (Throwable ex) {
            return Collections.emptySet();
        }
    }
}

