/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.init;

import java.util.Collections;
import java.util.Set;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.jdbc.init.BeansOfTypeDetector;
import org.springframework.boot.jdbc.init.DataSourceInitializerDetector;

public abstract class AbstractBeansOfTypeDataSourceInitializerDetector
implements DataSourceInitializerDetector {
    protected abstract Set<Class<?>> getDataSourceInitializerBeanTypes();

    @Override
    public Set<String> detect(ConfigurableListableBeanFactory beanFactory) {
        try {
            Set<Class<?>> types = this.getDataSourceInitializerBeanTypes();
            return new BeansOfTypeDetector(types).detect((ListableBeanFactory)beanFactory);
        }
        catch (Throwable ex) {
            return Collections.emptySet();
        }
    }
}

