/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging;

import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.springframework.boot.logging.LogFile;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggerConfiguration;
import org.springframework.boot.logging.LoggingInitializationContext;
import org.springframework.boot.logging.java.JavaLoggingSystem;
import org.springframework.boot.logging.log4j2.Log4J2LoggingSystem;
import org.springframework.boot.logging.logback.LogbackLoggingSystem;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class LoggingSystem {
    public static final String SYSTEM_PROPERTY = LoggingSystem.class.getName();
    public static final String NONE = "none";
    public static final String ROOT_LOGGER_NAME = "ROOT";
    private static final Function<ClassLoader, LoggingSystem> SYSTEM_FACTORY = LoggingSystem.getSystemFactory();

    private static Function<ClassLoader, LoggingSystem> getSystemFactory() {
        ClassLoader classLoader = LoggingSystem.class.getClassLoader();
        if (ClassUtils.isPresent((String)"ch.qos.logback.core.Appender", (ClassLoader)classLoader)) {
            return LogbackLoggingSystem::new;
        }
        if (ClassUtils.isPresent((String)"org.apache.logging.log4j.core.impl.Log4jContextFactory", (ClassLoader)classLoader)) {
            return Log4J2LoggingSystem::new;
        }
        if (ClassUtils.isPresent((String)"java.util.logging.LogManager", (ClassLoader)classLoader)) {
            return JavaLoggingSystem::new;
        }
        throw new IllegalStateException("No suitable logging system located");
    }

    public abstract void beforeInitialize();

    public void initialize(LoggingInitializationContext initializationContext, String configLocation, LogFile logFile) {
    }

    public void cleanUp() {
    }

    public Runnable getShutdownHandler() {
        return null;
    }

    public Set<LogLevel> getSupportedLogLevels() {
        return EnumSet.allOf(LogLevel.class);
    }

    public void setLogLevel(String loggerName, LogLevel level) {
        throw new UnsupportedOperationException("Unable to set log level");
    }

    public List<LoggerConfiguration> getLoggerConfigurations() {
        throw new UnsupportedOperationException("Unable to get logger configurations");
    }

    public LoggerConfiguration getLoggerConfiguration(String loggerName) {
        throw new UnsupportedOperationException("Unable to get logger configuration");
    }

    public static LoggingSystem get(ClassLoader classLoader) {
        String loggingSystem = System.getProperty(SYSTEM_PROPERTY);
        if (StringUtils.hasLength((String)loggingSystem)) {
            if (NONE.equals(loggingSystem)) {
                return new NoOpLoggingSystem();
            }
            return LoggingSystem.get(classLoader, loggingSystem);
        }
        return SYSTEM_FACTORY.apply(classLoader);
    }

    private static LoggingSystem get(ClassLoader classLoader, String loggingSystemClass) {
        try {
            Class systemClass = ClassUtils.forName((String)loggingSystemClass, (ClassLoader)classLoader);
            Constructor constructor = systemClass.getDeclaredConstructor(ClassLoader.class);
            constructor.setAccessible(true);
            return (LoggingSystem)constructor.newInstance(classLoader);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    static class NoOpLoggingSystem
    extends LoggingSystem {
        NoOpLoggingSystem() {
        }

        @Override
        public void beforeInitialize() {
        }

        @Override
        public void setLogLevel(String loggerName, LogLevel level) {
        }

        @Override
        public List<LoggerConfiguration> getLoggerConfigurations() {
            return Collections.emptyList();
        }

        @Override
        public LoggerConfiguration getLoggerConfiguration(String loggerName) {
            return null;
        }
    }
}

